package de.fzi.kamp.ui.workplanderivation.wizards;

import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class InitialWiazardElementsFactory {
    private final static Logger logger = Logger.getLogger(InitialWiazardElementsFactory.class);

    private static SurfaceFactory factory = new SurfaceFactory();
    
    public static Table createTableForInterfacePortSelection(Composite container, boolean previousIsComponent) {
        String[] headings = {};
        if (previousIsComponent) {
            headings = new String[] { "!", "Component Name", "Interface Port", "Type", "Basic Activity", "SC?*" };
        } else {
            headings = new String[] { "!", "Interface Name", "Component.Interface Port", "Type", "Basic Activity",
                    "SC?*" };
        }
        return createTableWithSignatureChangeAnnotation(container, headings);
    }

    public static Table createTableForOperations(Composite container) {
        String[] headings = new String[] { "!", "Component.Interface Port", "Operation", "Basic Activity", "SC?*" };

        return createTableWithSignatureChangeAnnotation(container, headings);
    }

    private static Table createTableWithSignatureChangeAnnotation(Composite container, String[] headings) {
        Table table = factory.createTable(container, 1, headings, SWT.FILL, true);
        factory.setGrabVerticalForGridData(table, true, SWT.FILL);
        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });

        Label annotation = new Label(container, SWT.NONE);
        annotation.setText("* SC = Signature Change");

        return table;
    }

    public static Combo createComboForBasicActivity(BasicActivity previousBasicActivity, Table parentTable,
            TableItem tableItem, int columnNumber) {

        Combo basicActivityCombo = null;

        switch (previousBasicActivity) {
        case ADD:
            basicActivityCombo = factory.createCombo(tableItem, new String[] { BasicActivity.ADD.toString() },
                    parentTable, SelectInterfacePortPage.getBasicActivityColumnNumber());
            break;

        case CHANGE:
            basicActivityCombo = factory.createCombo(tableItem, new String[] { BasicActivity.ADD.toString(),
                    BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString() }, parentTable,
                    SelectInterfacePortPage.getBasicActivityColumnNumber());
            break;

        case REMOVE:
            basicActivityCombo = factory.createCombo(tableItem,
                    new String[] { BasicActivity.REMOVE.toString() }, parentTable, SelectInterfacePortPage
                            .getBasicActivityColumnNumber());
            break;
        }

        return basicActivityCombo;
    }

    public static Combo createPlaceboBasicActivityCombo(Table table, TableItem itemForAssociatedInterface) {
        Combo placeboCombo = new Combo(table, SWT.READ_ONLY);
        placeboCombo.setItems(new String[] { BasicActivity.REMOVE.toString() });
        placeboCombo.setEnabled(false);
        factory.setControlWithTableEditor(table, itemForAssociatedInterface, placeboCombo,
                SelectInterfacePortPage.getBasicActivityColumnNumber());
        return placeboCombo;
    }

    public static Button createPlaceboSelectionCheckbox(Table table, TableItem itemForAssociatedInterface) {
        Button placeboCheckbox = new Button(table, SWT.CHECK);
        placeboCheckbox.setEnabled(false);
        placeboCheckbox.setToolTipText("It is unnecessary to choose further activities if the parent is removed");
        factory.setControlWithTableEditor(table, itemForAssociatedInterface, placeboCheckbox,
                SelectInterfacePortPage.getSelectionCheckboxColumnNumber());
        return placeboCheckbox;
    }
}
