package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizards.InitialWiazardElementsFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

public class SelectOperationPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(SelectOperationPage.class);

    private SurfaceFactory factory;
    private Composite container;
    private boolean justChange;
    private CompositeTaskDerivationContainer workplanContainer;

    private static final String SELECTIONCHECKBOX_TOOLTIP = "Check this, if this operation is affected within the current composite activity.";
    private static final String SIGNATURECHANGE_CHECKBOX_TOOLTIP = "Check this, if a signature change is performed with this operation.";

    private static final int POSITION_SELECTIONCHECKBOX = 0;
    private static final int POSITION_INTERFACEPORT = 1;
    private static final int POSITION_OPERATION = 2;
    private static final int POSITION_BASICACTIVITY = 3;
    private static final int POSITION_SIGNATURECHANGE = 4;

    private Map<OperationImplementationSelectionContainer, OperationSelectionContainerDecorator> container2decoratorMap;

    protected SelectOperationPage(CompositeTaskDerivationContainer workplanContainer) {
        super("");

        setTitle("Select Operation Activities");
        setDescription("Please detail your change description on operation level:\n" + "Which operations are affected?");

        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
//        this.container2decoratorMap = new HashMap<OperationSelectionContainer, OperationSelectionContainerDecorator>();
        this.justChange = false;
    }
    
    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }


    @Override
    public void createControl(Composite parent) {

        container = factory.createCompositeOrGroup(parent, 1, SWT.FILL, 1, SWT.NONE, false, 0, 0);
        createTable();

        setControl(container);
    }

    /**
     * Creates the central table to display the operations.
     */
    public void createTable() {

        Table table = InitialWiazardElementsFactory.createTableForOperations(container);
        factory.setControlHeight(table, 200);

        if (((InitialForkPage) getWizard().getPage("forkPage")).getFirstPage() instanceof SelectComponentActivitiesWizardPage) {
            // In case that the derivation process began with the selection of components
            setContentForComponentBeginning(table);
        } else {
            // The "justChange" boolean marks that in case of interfaces and datatypes just the
            // basic activity "change"
            // could be chosen in the derivation process.
            this.justChange = true;

            // In case that the derivation process began with the selection of interfaces
            if (((InitialForkPage) getWizard().getPage("forkPage")).getFirstPage() instanceof SelectInterfacesPage) {
                setContentForInterfaceBeginning(table);
            } else {
                // In case that the derivation process began with the selection of datatypes
                setContentForDatatypesBeginning(table);
            }
        }
        getShell().pack();
    }

    /*
     * The following three methods navigate the selection of the operation to display in dependence
     * on the architecture element type with which the derivation process began.
     * 
     * @param table
     */

    private void setContentForDatatypesBeginning(Table table) {
        if (this.workplanContainer.getLastShownDataTypeSelectionContainers().size() > 0) {
            for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer
                    .getLastShownDataTypeSelectionContainers()) {
                if (datatypeContainer.isSelected()) {
                    for (InterfaceSelectionContainer ifaceContainer : datatypeContainer
                            .getSelectedInterfaceSelectionContainers()) {
                        if (!ifaceContainer.getFollowups().isEmpty() && ifaceContainer.isSelected())
                            for (InterfacePortSelectionContainer ifacePortContainer : ifaceContainer.getFollowups()) {
                                if (ifaceContainer.isSelected())
                                    fillTable(ifacePortContainer, table);
                            }
                    }
                }
            }
        }
    }

    private void setContentForInterfaceBeginning(Table table) {
        if (this.workplanContainer.getLastShownInterfaceContainers().size() > 0) {
            for (InterfaceSelectionContainer selectedInterface : this.workplanContainer
                    .getLastShownInterfaceContainers()) {
                if (!selectedInterface.getFollowups().isEmpty() && selectedInterface.isSelected())
                    for (InterfacePortSelectionContainer followUp : selectedInterface.getFollowups()) {
                        if (followUp.isSelected())
                            fillTable(followUp, table);
                    }
            }
        }
    }

    private void setContentForComponentBeginning(Table table) {
        if (this.workplanContainer.getLastShownComponentContainers().size() > 0) {
            for (ComponentSelectionContainer selectedComponent : this.workplanContainer
                    .getLastShownComponentContainers()) {
                if (!selectedComponent.getRefinements().isEmpty() && selectedComponent.isSelected()) {
                    for (InterfacePortSelectionContainer refinement : selectedComponent.getRefinements()) {
                        if (refinement.isSelected())
                            fillTable(refinement, table);
                    }
                }
            }
        }
    }

    /**
     * Fills the table with a table item for each operation which is attached to an interface port.
     * Information about the parent interface port and the component is added next to the name of
     * the operation itself. Two checkboxes and the combo to choose the basic activity are created,
     * too.
     * 
     * @param interfacePortContainer
     * @param table
     */
    private void fillTable(InterfacePortSelectionContainer interfacePortContainer, Table table) {

//        for (OperationSelectionContainer operationContainer : interfacePortContainer.getRefinements()) {
//
//            TableItem itemForAssociatedOperation = new TableItem(table, SWT.NONE);
//            itemForAssociatedOperation.setFont(factory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));
//
//            if (operationContainer.getOperation() != null) {
//                // Setting the Component.InterfacePort string.
//                itemForAssociatedOperation.setText(POSITION_INTERFACEPORT, interfacePortContainer.getParent()
//                        .getComponenttype().getName()
//                        + "." + interfacePortContainer.getInterfaceport().getName());
//                // Setting the operation name.
//                itemForAssociatedOperation.setText(POSITION_OPERATION, operationContainer.getOperation().getName());
//
//                Button selectionCheckbox = new Button(table, SWT.CHECK);
//                factory.setControlWithTableEditor(table, itemForAssociatedOperation, selectionCheckbox,
//                        POSITION_SELECTIONCHECKBOX);
//                selectionCheckbox.setToolTipText(SELECTIONCHECKBOX_TOOLTIP);
//
//                Button signatureChangeButton = new Button(table, SWT.CHECK);
//                factory.setControlWithTableEditor(table, itemForAssociatedOperation, signatureChangeButton,
//                        POSITION_SIGNATURECHANGE);
//                signatureChangeButton.setEnabled(false);
//                signatureChangeButton.setToolTipText(SIGNATURECHANGE_CHECKBOX_TOOLTIP);
//
//                Combo basicActivityCombo = createBasicActivityCombo(itemForAssociatedOperation, interfacePortContainer,
//                        table);
//
//                OperationSelectionContainerDecorator operationDecorator = createDecorator(operationContainer,
//                        itemForAssociatedOperation, selectionCheckbox, basicActivityCombo);
//                operationDecorator.setSignatureChangeCheckbox(signatureChangeButton);
//
//                if (operationContainer.isSelected()) {
//                    selectionCheckbox.setSelection(true);
//                    selectionCheckbox.setEnabled(false);
//                    basicActivityCombo.setText(operationContainer.getBasicActivity().toString());
//                }
//
//                selectionCheckbox.addSelectionListener(new OperationCheckBoxListener(this, operationDecorator,
//                        interfacePortContainer));
//                signatureChangeButton.addSelectionListener(new SignatureChangeOperationCheckboxListener(
//                        operationDecorator));
//                basicActivityCombo.addSelectionListener(new OperationComboListener(this, operationDecorator,
//                        this.justChange));
//            }
//        }

        for (TableColumn column : table.getColumns()) {
            column.pack();
        }

//        setPageComplete(checkedAndSelected());
    }

    /**
     * Creates and returns the combo where the basic activity for the operation can be chosen.
     * 
     * @param itemForAssociatedOperation
     * @param interfacePortContainer
     * @param table
     * @return
     */
    private Combo createBasicActivityCombo(TableItem itemForAssociatedOperation,
            InterfacePortSelectionContainer interfacePortContainer, Table table) {

        Combo combo = null;
        if (this.justChange) {
            return combo = factory.createCombo(itemForAssociatedOperation, new String[] { BasicActivity.CHANGE
                    .toString() }, table, 3);
        } else {
            switch (interfacePortContainer.getBasicActivity()) {
            case ADD:
                combo = factory.createCombo(itemForAssociatedOperation, new String[] { BasicActivity.ADD
                        .toString() }, table, POSITION_BASICACTIVITY);
                break;
            case CHANGE:
                combo = factory.createCombo(itemForAssociatedOperation,
                        new String[] { BasicActivity.ADD.toString(), BasicActivity.CHANGE.toString(),
                                BasicActivity.REMOVE.toString() }, table, POSITION_BASICACTIVITY);
                break;
            case REMOVE:
                combo = factory.createCombo(itemForAssociatedOperation, new String[] { BasicActivity.REMOVE
                        .toString() }, table, POSITION_BASICACTIVITY);
                combo.setText(BasicActivity.REMOVE.toString());
                break;
            default:
                combo = new Combo(table, SWT.NONE)/* Maybe insert exception */;
            }
        }
        combo.setToolTipText("Please specify the basic activity for this operation.");
        combo.setEnabled(false);

        return combo;
    }

    /**
     * Creates the decorator which wraps the actual operation container together with the combo and
     * the two checkboxes for the selection of the operation and the marking whether there is a
     * signature change performed or not.
     * 
     * @param operationContainer
     * @param itemForAssociatedOperation
     * @param checkbox
     * @param combo
     * @return
     */
    private OperationSelectionContainerDecorator createDecorator(OperationImplementationSelectionContainer operationContainer,
            TableItem itemForAssociatedOperation, Button checkbox, Combo combo) {
        OperationSelectionContainerDecorator decorator = new OperationSelectionContainerDecorator(operationContainer);

        container2decoratorMap.put(operationContainer, decorator);

        itemForAssociatedOperation.setData(operationContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedOperation);

        this.workplanContainer.getLastShownOperationSelectionContainer().add(operationContainer);
        return decorator;
    }

    public boolean checkedAndSelected() {

        setErrorMessage(null);

        List<OperationImplementationSelectionContainer> selectedItems = this.workplanContainer
                .getLastShownOperationSelectionContainer();

        if (selectedItems.size() < 1) {
            return false;
        } else {
            boolean checkedAndSelected = true;

            for (OperationImplementationSelectionContainer abstractContainer : selectedItems) {

                if (abstractContainer.getBasicActivity() == BasicActivity.REMOVE)
                    return true;

                OperationSelectionContainerDecorator container = container2decoratorMap.get(abstractContainer);

                if (abstractContainer.getBasicActivity() == null) {

                    container.getTableItem().setBackground(4,
                            factory.lookupColor(getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                    setErrorMessage("If you check a component, you have to chose a basic activity");
                    checkedAndSelected = false;
                } else {
                    container.getTableItem().setBackground(4,
                            factory.lookupColor(getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
                }
            }

            return checkedAndSelected;
        }
    }
}
