package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfaceCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfaceComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;

public class SelectInterfacesPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(SelectInterfacesPage.class);

    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private DataTypeSelectionContainer temporaryDataTypeContainer;

    private SurfaceFactory factory = new SurfaceFactory();
    
    private Map<InterfaceSelectionContainer, InterfaceSelectionContainerDecorator> container2decoratorMap;

    protected SelectInterfacesPage(CompositeTaskDerivationContainer workplanContainer) {
        super("interfacePage");
        setTitle("Select Interface Activities");
        setDescription("Please chose the interfaces which are affected by the\n" + "your change request.");

        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.container2decoratorMap = new HashMap<InterfaceSelectionContainer, InterfaceSelectionContainerDecorator>();
        this.temporaryDataTypeContainer = SelectioncontainerFactoryImpl.eINSTANCE.createDataTypeSelectionContainer();
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }

    
    @Override
    public void createControl(Composite parent) {

        Composite container = this.factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        // Label label = new Label(parent, SWT.NONE);
        // label.setText("hallo");

        Table table = this.factory.createTable(container, 1, new String[] { "!", "Datatype", "Interface",
                "Basic Activity" }, SWT.FILL, true);
        this.factory.setGrabVerticalForGridData(table, true, SWT.FILL);

        if (getPreviousPage() instanceof SelectDatatypesPage) {
            for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer
                    .getLastShownDataTypeSelectionContainers()) {

                if (datatypeContainer.isSelected()) {

                    TableItem item = new TableItem(table, SWT.NONE);
                    item.setText(1, datatypeContainer.getType().getName());

                    this.temporaryDataTypeContainer = datatypeContainer;
                    createTableForInterfaces(datatypeContainer.getCompleteInterfaceSelectionContainers(), table);
                }
            }
        } else {
            createTableForInterfaces(this.workplanContainer.getInterfaceSelectionContainers(), table);

        }

        setControl(container);
        setTitle("Choose your interfaces, please");

        getShell().pack();

        // table.update();
        // table.redraw();
        // table.pack();
    }

    private void createTableForInterfaces(List<InterfaceSelectionContainer> interfaceList, Table table) {

        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });

        for (InterfaceSelectionContainer ifaceContainer : interfaceList) {

            TableItem item = new TableItem(table, SWT.NONE);
            item.setText(2, ifaceContainer.getReferencedInterface().getName());
            item.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));

            table.getColumn(2).pack();
            table.update();

            Button checkbox = new Button(table, SWT.CHECK);
            setControlWithEditor(table, item, checkbox, 0);

            checkbox.setToolTipText("Check this, if this interface is affected within the current composite activity.");

            table.getColumn(0).pack();
            table.update();

            Combo combo = new Combo(table, SWT.READ_ONLY);
            combo.add(BasicActivity.ADD.toString());
            combo.add(BasicActivity.CHANGE.toString());
            // combo.add("Remove");
            combo.setEnabled(false);
            setControlWithEditor(table, item, combo, 3);

            combo.setToolTipText("Please specify the basic activity for this interface.");

            table.getColumn(2).pack();
            table.redraw();

            InterfaceSelectionContainerDecorator decorator = new InterfaceSelectionContainerDecorator(ifaceContainer);

            this.container2decoratorMap.put(ifaceContainer, decorator);

            item.setData(ifaceContainer);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);

            this.workplanContainer.getLastShownInterfaceContainers().add(ifaceContainer);

            if (getPreviousPage() instanceof SelectDatatypesPage)
                checkbox.addSelectionListener(new InterfaceCheckboxListener(decorator, this,
                        this.temporaryDataTypeContainer));
            else
                checkbox.addSelectionListener(new InterfaceCheckboxListener(decorator, this));

            combo.addSelectionListener(new InterfaceComboListener(this, decorator));

            if (ifaceContainer.isSelected()) {
                checkbox.setSelection(true);
                checkbox.setEnabled(false);
                combo.setText(combo.getItem(0));
            }
        }
    }

    private void setControlWithEditor(Table table, TableItem item, Control control, int column) {

        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
        editor.layout();
    }

    public boolean checkedAndSelected() {

        setErrorMessage(null);

        List<InterfaceSelectionContainer> selectedInterfaces = this.workplanDerivationManager.getSelectedInterfaces();
        if (selectedInterfaces.isEmpty()) {
            return false;
        } else {
            boolean checkedAndSelected = true;

            for (InterfaceSelectionContainer interfaceContainer : selectedInterfaces) {

                InterfaceSelectionContainerDecorator selection = container2decoratorMap.get(interfaceContainer);

                if (interfaceContainer.getBasicActivity() == null) {
                    selection.getTableItem().setBackground(2,
                            this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                    setErrorMessage("If you check a component, you have to choose a basic activity");
                    checkedAndSelected = false;

                } else {
                    try {
                        selection.getTableItem().setBackground(2,
                                this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
                    } catch (Exception e) {
                        logger.warn("Exception during backgroud color setting: "+ e.getLocalizedMessage());
                    }
                }
            }
            return checkedAndSelected;
        }
    }
}
