package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.DataTypeSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.DataTypeCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.DataTypesComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;

public class SelectDatatypesPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(SelectDatatypesPage.class);

    private SurfaceFactory factory;
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private Map<DataTypeSelectionContainer, DataTypeSelectionContainerDecorator> container2decoratorMap;

    protected SelectDatatypesPage(CompositeTaskDerivationContainer workplanContainer) {
        super("datatypePage");

        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.container2decoratorMap = new HashMap<DataTypeSelectionContainer, DataTypeSelectionContainerDecorator>();
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }
    
    public void createControl(Composite parent) {
        this.setTitle("Select the activities you are going\n to perform for Datatypes");

        Composite container = factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);
        setControl(container);

        setDescription("Please check the datatypes affected by your change request.");

        Table table = this.factory.createTable(container, 1, new String[] { "!", "Datatype", "Basic Activity" },
                SWT.FILL, true);
        this.factory.setGrabVerticalForGridData(table, true, SWT.FILL);

        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });

        for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getDataTypeSelectionContainers()) {

            TableItem item = new TableItem(table, SWT.NONE);
            item.setText(1, datatypeContainer.getType().getName());
            item.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));

            table.getColumn(1).pack();

            Button checkbox = new Button(table, SWT.CHECK);
            this.factory.setControlWithTableEditor(table, item, checkbox, 0);

            checkbox.setToolTipText("Check this, if the datatype is affected within the current composite activity.");

            table.getColumn(0).pack();
            table.update();

            Combo combo = new Combo(table, SWT.READ_ONLY);
            combo.add(BasicActivity.CHANGE.toString());
            combo.setEnabled(false);
            this.factory.setControlWithTableEditor(table, item, combo, 2);

            combo.setToolTipText("Please specify the basic activity for this datatype.");

            table.getColumn(2).pack();
            table.redraw();

            DataTypeSelectionContainerDecorator decorator = new DataTypeSelectionContainerDecorator(datatypeContainer);

            this.container2decoratorMap.put(datatypeContainer, decorator);

            item.setData(datatypeContainer);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);

            this.workplanContainer.getLastShownDataTypeSelectionContainers().add(datatypeContainer);

            checkbox.addSelectionListener(new DataTypeCheckboxListener(this, decorator));
            combo.addSelectionListener(new DataTypesComboListener(this, decorator));
            setPageComplete(true);

            if (datatypeContainer.isSelected()) {
                checkbox.setSelection(true);
                checkbox.setEnabled(false);
                combo.setText(combo.getItem(0));
            }
        }

    }

    public boolean checkedAndSelected() {

        setErrorMessage(null);

        List<DataTypeSelectionContainer> selectedDatatypes = this.workplanDerivationManager.getSelectedDatatypes();
        if (selectedDatatypes.isEmpty()) {
            return false;
        } else {
            boolean checkedAndSelected = true;

            for (DataTypeSelectionContainer datatypeContainer : selectedDatatypes) {

                DataTypeSelectionContainerDecorator selection = container2decoratorMap.get(datatypeContainer);

                if (datatypeContainer.getBasicActivity() == null) {
                    selection.getTableItem().setBackground(2,
                            this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                    setErrorMessage("If you check a component, you have to choose a basic activity");
                    checkedAndSelected = false;

                } else {
                    selection.getTableItem().setBackground(2,
                            this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
                }
            }

            return checkedAndSelected;
        }
    }
}
