package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.ComponentSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.ComponentCheckBoxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.ComponentComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;

public class SelectComponentActivitiesWizardPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(SelectComponentActivitiesWizardPage.class);

    private SurfaceFactory factory;
    private Table table;
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private Map<ComponentSelectionContainer, ComponentSelectionContainerDecorator> container2decoratorMap;

    public SelectComponentActivitiesWizardPage(CompositeTaskDerivationContainer workplanContainer) {
        super("compPage");

        setTitle("Select Component Activities");
        setDescription("Please mark the components which are affected by changes. For marked components please specify what basic activity (ADD, CHANGE, or REMOVE) is performed.");

        this.container2decoratorMap = new HashMap<ComponentSelectionContainer, ComponentSelectionContainerDecorator>();

        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }
    
    @Override
    public void createControl(Composite parent) {

        Composite container = this.factory.createCompositeOrGroup(parent, 1, SWT.FILL, 1, SWT.NONE, false, 0, 0);
        setControl(container);

        table = this.factory.createTable(container, 1, new String[] { "!", "Component", "Basic Activity" }, SWT.FILL, true);
        factory.setGrabVerticalForGridData(table, true, SWT.FILL);

        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });

        for (ComponentSelectionContainer componentContainer : this.workplanContainer.getComponentContainers()) {

            TableItem item = new TableItem(table, SWT.NONE);
            item.setText(1, componentContainer.getComponenttype().getName());
            item.setFont(this.factory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER));

            table.getColumn(1).pack();
            table.update();

            Button checkbox = new Button(table, SWT.CHECK);
            checkbox.setSelection(false);
            setControlWithEditor(table, item, checkbox, 0);

            checkbox.setToolTipText("Check this, if the component is affected within the current composite activity.");

            table.getColumn(0).pack();
            table.update();

            Combo combo = configureBasicActivityCombo(item);

            combo.setToolTipText("Please specify the basic activity regarding this component.");

            table.getColumn(2).pack();
            table.redraw();

            table.pack();
            ComponentSelectionContainerDecorator decorator = new ComponentSelectionContainerDecorator(
                    componentContainer);
            this.container2decoratorMap.put(componentContainer, decorator);

            item.setData(decorator);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);

            // TODO
            this.workplanDerivationManager.addShowedComponent(componentContainer);

            checkbox.addSelectionListener(new ComponentCheckBoxListener(this, decorator));
            combo.addSelectionListener(new ComponentComboListener(this, decorator));
        }
        setPageComplete(checkedAndSelected());
    }

    private Combo configureBasicActivityCombo(TableItem item) {
        Combo combo = new Combo(table, SWT.READ_ONLY);
        combo.add(BasicActivity.ADD.toString());
        combo.add(BasicActivity.CHANGE.toString());
        combo.add(BasicActivity.REMOVE.toString());
        combo.setEnabled(false);
        setControlWithEditor(table, item, combo, 2);
        return combo;
    }

    private void setControlWithEditor(Table table, TableItem item, Control control, int column) {

        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
        editor.layout();

    }

    public boolean checkedAndSelected() {

        setErrorMessage(null);

        List<ComponentSelectionContainer> selectedComponents = this.workplanDerivationManager.getSelectedComponents();

        if (selectedComponents.isEmpty()) {
            return false;
        } else {
            boolean checkedAndSelected = true;

            for (ComponentSelectionContainer componentContainer : selectedComponents) {

                ComponentSelectionContainerDecorator decorator = this.container2decoratorMap.get(componentContainer);

                if (componentContainer.getBasicActivity() == null) {
                    if (decorator != null) {
                        decorator.getTableItem().setBackground(2,
                                this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                    }
                    setErrorMessage("If you check a component, you have to choose a basic activity");
                    checkedAndSelected = false;
                } else {
                    if (decorator != null) {
                        decorator.getTableItem().setBackground(2,
                                this.factory.lookupColor(getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
                    }
                }
            }
            return checkedAndSelected;
        }
    }
}
