package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.RationalTextfieldsModifyListener;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;

public class NamingChangingRationalPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(NamingChangingRationalPage.class);

    private TaskRationale rationale;
    private Text textForKeyword;
    private Text textForDescription;

    private SurfaceFactory factory;

    protected NamingChangingRationalPage(TaskRationale rationale) {
        super("rationalPage");
        this.rationale = rationale;
        this.factory = new SurfaceFactory();
    }

    @Override
    public void createControl(Composite parent) {

        setTitle("Specify New Composite Activity");
        setDescription("Please describe why and what you are going to change in the software system regarding the current change request.\n"
                + "By specifying composite activities you can structure work description in semantical related pieces (i.e. milestones).\n"
                + "Please provide a keyword and a longer description for each composite activity.\n");

        Composite container = factory.createCompositeOrGroup(parent, 1, SWT.FILL, 1, SWT.NONE, true, 5, 5);

        createKeywordPart(container);
        createDescriptionPart(container);

        setControl(container);
    }

    private void createKeywordPart(Composite container) {

        Label keyword = new Label(container, SWT.NONE);
        keyword.setText("Keyword:");
        keyword.setFont(factory.getFontStyle().get(SurfaceFactory.STYLE_QUESTION));

        this.textForKeyword = new Text(container, SWT.SINGLE | SWT.BORDER);
        textForKeyword.setTextLimit(30);
        textForKeyword.setMessage("30 characters allowed");

        textForKeyword.addModifyListener(new RationalTextfieldsModifyListener(this.textForKeyword, this,
                this.rationale, true));

    }

    private void createDescriptionPart(Composite container) {

        Label description = new Label(container, SWT.NONE);
        description.setText("Description:");
        factory.setGridLayout(description, SWT.LEFT, true, 1);
        description.setFont(factory.getFontStyle().get(SurfaceFactory.STYLE_QUESTION));

        this.textForDescription = new Text(container, SWT.MULTI | SWT.BORDER);
        factory.setGridLayout(textForDescription, SWT.FILL, true, 1);
        factory.setGrabVerticalForGridData(textForDescription, true, SWT.FILL);

        textForDescription.addModifyListener(new RationalTextfieldsModifyListener(this.textForDescription, this,
                this.rationale, false));
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.textForDescription.getText().length() > 0 && this.textForKeyword.getText().length() > 0)
            return true;
        else
            return false;
    }

}
