package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.GoToDeriveComponentsPageListener;
import de.fzi.kamp.ui.workplanderivation.listeners.GoToDeriveDatatypeDefinitionsPageListener;
import de.fzi.kamp.ui.workplanderivation.listeners.GoToDeriveInterfacesPageListener;
import de.fzi.kamp.ui.workplanderivation.listeners.NavigationButtonsListener;

public class InitialForkPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(InitialForkPage.class);

    private SurfaceFactory factory;
    private int selectionIndex;
    private IWizardPage firstPage;

    public InitialForkPage() {
        super("forkPage");

        this.factory = new SurfaceFactory();
        this.selectionIndex = -1;
    }

    @Override
    public void createControl(Composite parent) {
        setTitle("Select Derivation Starting Point");
        setDescription("Choose the way you want to go through the derivation process.");

        Composite container = this.factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        NavigationButtonsListener[] listener = {
                new GoToDeriveComponentsPageListener((DeriveWorkPlanWizard) getWizard()),
                new GoToDeriveInterfacesPageListener((DeriveWorkPlanWizard) getWizard()),
                new GoToDeriveDatatypeDefinitionsPageListener((DeriveWorkPlanWizard) getWizard()) };

        String[] tooltips = new String[] { "Select this if you can directly point out affected components.",
                "Select this if you can directly point out affected interfaces.",
                "Select this if you can directly point out affected datatypes." };

        Composite buttons = this.factory.createVerticalButtonComposite(container, SWT.CENTER, SWT.FILL, new String[] {
                "Component Change", "Interface Change", "Datatype Definition Change" }, SWT.NONE, listener, tooltips);

        ((GridLayout) buttons.getLayout()).verticalSpacing = 15;
        ((GridData) buttons.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData) buttons.getLayoutData()).verticalAlignment = SWT.CENTER;

        setControl(container);
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    public int getSelectionIndex() {
        return selectionIndex;
    }

    public void setSelectionIndex(int selectionIndex) {
        this.selectionIndex = selectionIndex;
    }

    /**
     * Returns the
     * 
     * @return
     */
    public IWizardPage getFirstPage() {
        return firstPage;
    }

    /**
     * In the listeners for the buttons (Components, Interfaces, Datatypes) the page is marked,
     * which has been the first to choose changes. It is important for the presentation of the
     * operations.
     * 
     * @param firstPage
     */
    public void setFirstPage(IWizardPage firstPage) {
        this.firstPage = firstPage;
    }
}
