package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.commands.DeriveWorkplanCommand;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.CompositeTaskDerivationContainerBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;

public class DeriveWorkPlanWizard extends AbstractWizard implements IWizard {
    private final static Logger logger = Logger.getLogger(DeriveWorkPlanWizard.class);

    private CompositeTaskDerivationContainer milestoneContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private IMainEditor mainEditor;
    private EffortAnalysisInstance analysisInstance;

    private InitialForkPage forkPage;
    private NamingChangingRationalPage rationalPage;
    private SelectComponentActivitiesWizardPage compPage;
    private SelectInterfacePortPage interfacePortPage;
    private SelectOperationPage operationPage;
    private SelectInterfacesPage interfacePage;
    private SelectDatatypesPage datatypePage;

    private IWizardPage activePage;

    public DeriveWorkPlanWizard(EffortAnalysisInstance instance, IMainEditor editor,
            IArchitectureModelProvider architectureModelProvider) {
        super();

        this.analysisInstance = instance;
        createMilestoneContainer(architectureModelProvider);
        this.workplanDerivationManager = new WorkplanDerivationManager(this.milestoneContainer);
        this.mainEditor = editor;

        this.rationalPage = new NamingChangingRationalPage(((CompositeTask) milestoneContainer.getActivity())
                .getTaskrationale());
        this.forkPage = new InitialForkPage();
        this.compPage = new SelectComponentActivitiesWizardPage(this.milestoneContainer);
        this.interfacePortPage = new SelectInterfacePortPage(this.milestoneContainer);
        this.operationPage = new SelectOperationPage(this.milestoneContainer);
        this.interfacePage = new SelectInterfacesPage(this.milestoneContainer);
        this.datatypePage = new SelectDatatypesPage(this.milestoneContainer);
        this.activePage = compPage;        
    }

    private void cleanup() {
        this.rationalPage.dispose();
        this.forkPage.dispose();
        this.compPage.dispose();
        this.interfacePortPage.dispose();
        this.interfacePage.dispose();
        this.datatypePage.dispose();
    }
    
    
    @Override
    public boolean performFinish() {
        this.cleanup();

        DeriveWorkplanCommand command = new DeriveWorkplanCommand(this.analysisInstance.getWorkplan(), this.mainEditor,
                this.milestoneContainer, this.workplanDerivationManager);
        this.mainEditor.handleCommand(command);

        if (getItemAdapter() != null) {
            getItemAdapter().notifyChanged(null);
        }
       
        return true;
    }
    
    @Override
    public boolean canFinish() {

        if (this.activePage == compPage)
            return true;
        if (this.activePage == interfacePortPage)
            return true;
        if (this.activePage == operationPage)
            return true;

        return super.canFinish();
    }

    public void addPages() {

        addPage(rationalPage);
        addPage(forkPage);
        addPage(compPage);
        addPage(interfacePortPage);
        addPage(operationPage);
        addPage(interfacePage);
        addPage(datatypePage);

        setWindowTitle("Select Work Activities");
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {

        if (page == rationalPage) {
            return forkPage;
        }

        if (page == compPage) {

            this.getPageList().remove(this.interfacePortPage);
            interfacePortPage = new SelectInterfacePortPage(milestoneContainer);
            addPage(interfacePortPage);

            this.activePage = interfacePortPage;
            return interfacePortPage;
        }

        if (page == interfacePortPage) {
            this.getPageList().remove(this.operationPage);
            operationPage = new SelectOperationPage(milestoneContainer);
            addPage(operationPage);

            this.activePage = operationPage;
            return operationPage;
        }

        if (page == interfacePage) {
            // if(page.getPreviousPage() instanceof SelectDatatypesPage){
            // this.getPageList().remove(this.IPDatatypesPage);
            // this.IPDatatypesPage = new
            // SelectInterfacePortForDatatypesPage(this.compositeTaskContainer);
            // addPage(IPDatatypesPage);
            //				
            // this.activePage = IPDatatypesPage;
            // return IPDatatypesPage;
            //				
            // }else{
            this.getPageList().remove(this.interfacePortPage);
            interfacePortPage = new SelectInterfacePortPage(milestoneContainer);
            addPage(interfacePortPage);

            this.activePage = interfacePortPage;
            return interfacePortPage;
            // }
        }

        if (page == datatypePage) {
            this.getPageList().remove(this.interfacePage);
            interfacePage = new SelectInterfacesPage(milestoneContainer);
            addPage(interfacePage);

            this.activePage = interfacePage;
            return interfacePage;
        }

        return super.getNextPage(page);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {

        if (page == compPage) {
            this.activePage = page;
            return null;
        }

        if (page == interfacePortPage) {
            this.activePage = compPage;
            return compPage;
        }

        if (page == operationPage) {
            this.activePage = interfacePortPage;
            return interfacePortPage;
        }

        if (page instanceof SelectInterfacesPage) {
            return null;
        }

        return super.getPreviousPage(page);
    }

    public List<ComponentSelectionContainer> getSelectedComponents() {
        return this.workplanDerivationManager.getSelectedComponents();
    }

    public int getSelectionIndex(AbstractContainer operationContainer) {

        switch (operationContainer.getBasicActivity()) {
        case ADD:
            return 0;
        case CHANGE:
            return 1;
        case REMOVE:
            return 2;
        }

        return -1;
    }
    
      @Override
    public boolean performCancel() {
        this.cleanup();
        this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().remove(this.milestoneContainer);
        return super.performCancel();
    }

    private AnalysisInstanceItemAdapter getItemAdapter() {
        for (Adapter adapter : this.analysisInstance.eAdapters()) {
            if (adapter instanceof AnalysisInstanceItemAdapter)
                return (AnalysisInstanceItemAdapter) adapter;
        }
        return null;
    }
    
    private void createMilestoneContainer(IArchitectureModelProvider architectureModelProvider){
    	this.milestoneContainer = SelectioncontainerFactoryImpl.eINSTANCE.createCompositeTaskDerivationContainer();
    	new CompositeTaskDerivationContainerBuilder(architectureModelProvider).buildProxyAndContainerStructureForMilestone(
            this.milestoneContainer, this.analysisInstance);
    	CompositeTask milestoneActivity = WorkplanFactory.eINSTANCE.createCompositeTask();
    	milestoneActivity.setTaskrationale(createEmptyTaskRationale());
    	this.milestoneContainer.setActivity(milestoneActivity);
    	
    	//The root composite component for complete workplan has been created in AnalysisInstanceManager.createRootWorkplan(...)
    	//Here the milestone is added to general list of composite containers
        this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().add(this.milestoneContainer);
        //Here the milestone container is added to the workplan root (which is also an composite task container)
        //[...].get(0) is ok, because per definition the first composite task container is the workplan root
    	this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().get(0).
    		getTopLevelActivityContainer().add(this.milestoneContainer);
    	
    	// FIXME: ADD ACTIVITY TO WORKPLAN - recheck!
    	this.analysisInstance.getWorkplan().getTasks().add(milestoneActivity);
    }
    
    private TaskRationale createEmptyTaskRationale(){
    	TaskRationale rationale = WorkplanFactory.eINSTANCE.createTaskRationale();
        rationale.setDescription("");
        rationale.setKeyword("");
        
        return rationale;
    }
    
    
}