package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.switches;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.util.SelectioncontainerSwitch;

public class RefinementHasActivitySwitch extends SelectioncontainerSwitch<boolean[]> {
    private final static Logger logger = Logger.getLogger(RefinementHasActivitySwitch.class);

    private boolean[] returningBooleanArray = { false };

    @Override
    public boolean[] caseCompositeTaskDerivationContainer(
            CompositeTaskDerivationContainer compositeTaskDerivationContainer) {
        for (AbstractContainer topLevelElement : compositeTaskDerivationContainer.getTopLevelActivityContainer()) {
            if (topLevelElement.getActivity() != null) {
                this.returningBooleanArray[0] = true;
                return this.returningBooleanArray;
            }
        }

        return this.returningBooleanArray;
    }

    @Override
    public boolean[] caseComponentSelectionContainer(ComponentSelectionContainer componentSelectionContainer) {
        for (InterfacePortSelectionContainer interfacePort : componentSelectionContainer.getRefinements()) {
            if (interfacePort.getActivity() != null) {
                this.returningBooleanArray[0] = true;
                return this.returningBooleanArray;
            }
        }
        return this.returningBooleanArray;
    }

    @Override
    public boolean[] caseInterfaceSelectionContainer(InterfaceSelectionContainer interfaceSelectionContainer) {
        for (InterfacePortSelectionContainer interfacePort : interfaceSelectionContainer.getFollowups()) {
            if (interfacePort.getActivity() != null) {
                this.returningBooleanArray[0] = true;
                return this.returningBooleanArray;
            }
        }
        return this.returningBooleanArray;
    }

    @Override
    public boolean[] caseInterfacePortSelectionContainer(InterfacePortSelectionContainer interfacePortSelectionContainer) {
        for (OperationImplementationSelectionContainer operationContainer : interfacePortSelectionContainer.getRefinements()) {
            if (operationContainer.getActivity() != null) {
                this.returningBooleanArray[0] = true;
                return this.returningBooleanArray;
            }
        }
        return this.returningBooleanArray;
    }

    @Override
    public boolean[] caseDataTypeSelectionContainer(DataTypeSelectionContainer dataTypeSelectionContainer) {
        for (InterfaceSelectionContainer interfaceContainer : dataTypeSelectionContainer
                .getCompleteInterfaceSelectionContainers()) {
            if (interfaceContainer.getActivity() != null) {
                this.returningBooleanArray[0] = true;
                return this.returningBooleanArray;
            }
        }
        return this.returningBooleanArray;
    }

    @Override
    public boolean[] caseAbstractContainer(AbstractContainer object) {
    	this.returningBooleanArray[0] = false;
        return this.returningBooleanArray;
    }
}
