package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.switches;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.util.SelectioncontainerSwitch;

/**
 * The array of potential children is returned. If the array is empty, then no children exist.
 * 
 * @author tknapp
 * 
 */
public class FurtherDerivationHasChildrenSwitch extends SelectioncontainerSwitch<Object[]> {

    @Override
    public Object[] caseCompositeTaskDerivationContainer(
            CompositeTaskDerivationContainer compositeTaskDerivationContainer) {
        return compositeTaskDerivationContainer.getTopLevelActivityContainer().toArray();
    }

    @Override
    public Object[] caseComponentSelectionContainer(ComponentSelectionContainer componentSelectionContainer) {
        return componentSelectionContainer.getRefinements().toArray();
    }

    @Override
    public Object[] caseInterfaceSelectionContainer(InterfaceSelectionContainer interfaceSelectionContainer) {
        return interfaceSelectionContainer.getFollowups().toArray();
    }

    @Override
    public Object[] caseInterfacePortSelectionContainer(InterfacePortSelectionContainer interfacePortSelectionContainer) {
        return interfacePortSelectionContainer.getRefinements().toArray();
    }

    @Override
    public Object[] caseDataTypeSelectionContainer(DataTypeSelectionContainer dataTypeSelectionContainer) {
        return dataTypeSelectionContainer.getCompleteInterfaceSelectionContainers().toArray();
    }
    
    @Override
    public Object[] caseOperationImplementationSelectionContainer(
    		OperationImplementationSelectionContainer object) {
    	return new Object[1];
    }
    
    @Override
    public Object[] caseOperationDefinitionSelectionContainer(
    		OperationDefinitionSelectionContainer object) {
    	return new Object[1];
    } 
}