package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.switches;

import java.util.List;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.util.SelectioncontainerSwitch;

public class FurtherDerivationGetChildrenSwitch extends SelectioncontainerSwitch<Object[]> {
    private final static Logger logger = Logger.getLogger(FurtherDerivationGetChildrenSwitch.class);

    @Override
    public Object[] caseCompositeTaskDerivationContainer(
            CompositeTaskDerivationContainer compositeTaskDerivationContainer) {
        return compositeTaskDerivationContainer.getTopLevelActivityContainer().toArray();
    }

    @Override
    public Object[] caseComponentSelectionContainer(ComponentSelectionContainer componentSelectionContainer) {
        List<?> test = componentSelectionContainer.getRefinements();
        return test.toArray();
    }

    @Override
    public Object[] caseInterfaceSelectionContainer(InterfaceSelectionContainer interfaceSelectionContainer) {
        return interfaceSelectionContainer.getFollowups().toArray();
    }

    @Override
    public Object[] caseInterfacePortSelectionContainer(InterfacePortSelectionContainer interfacePortSelectionContainer) {
        return interfacePortSelectionContainer.getRefinements().toArray();
    }

    @Override
    public Object[] caseDataTypeSelectionContainer(DataTypeSelectionContainer dataTypeSelectionContainer) {
        return dataTypeSelectionContainer.getCompleteInterfaceSelectionContainers().toArray();
    }
}
