package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.SelectElementTypesPage;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

public class FurtherDerivationtTreeLabelProvider implements ITableLabelProvider, ITableFontProvider {
    private final static Logger logger = Logger.getLogger(FurtherDerivationtTreeLabelProvider.class);

    private static final int COLUMN_NAME = SelectElementTypesPage.NAME_COLUMN_NO;
    private static final int COLUMN_TYPE = SelectElementTypesPage.ELEMENT_TYPE_COLUMN_NO;

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {

        if (element instanceof CompositeTaskDerivationContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((CompositeTask) ((CompositeTaskDerivationContainer) element).getActivity()).getTaskrationale()
                        .getKeyword();
            case COLUMN_TYPE:
                return "Component";
            }

        if (element instanceof ComponentSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((ComponentSelectionContainer) element).getComponenttype().getName();
            case COLUMN_TYPE:
                return "Component";
            }

        if (element instanceof InterfaceSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((InterfaceSelectionContainer) element).getReferencedInterface().getName();
            case COLUMN_TYPE:
                return "Interface";
            }

        if (element instanceof DataTypeSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((DataTypeSelectionContainer) element).getType().getName();
            case COLUMN_TYPE:
                return "Datatype";
            }

        if (element instanceof InterfacePortSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((InterfacePortSelectionContainer) element).getInterfaceport().getName();
            case COLUMN_TYPE:
                return "InterfacePort";
            }

        if (element instanceof OperationImplementationSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((OperationImplementationSelectionContainer) element).getOperation().getName();
            case COLUMN_TYPE:
                return "OperationImplementation";
            }
        
        if (element instanceof OperationDefinitionSelectionContainer)
            switch (columnIndex) {
            case COLUMN_NAME:
                return ((OperationDefinitionSelectionContainer) element).getAbstractOperation().getName();
            case COLUMN_TYPE:
                return "OperationImplementation";
            }

        return "";
    }

    @Override
    public void addListener(ILabelProviderListener listener) {

    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }

    @Override
    public Font getFont(Object element, int columnIndex) {
        return new SurfaceFactory().getFontStyle().get(SurfaceFactory.STYLE_ANSWER);
    }
}
