package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.switches.FurtherDerivationGetChildrenSwitch;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.switches.FurtherDerivationHasChildrenSwitch;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;

public class FurtherDerivationTreeContentProvider implements ITreeContentProvider {
    private final static Logger logger = Logger.getLogger(FurtherDerivationTreeContentProvider.class);

    @Override
    public Object[] getChildren(Object parentElement) {

        FurtherDerivationGetChildrenSwitch childrenSwitch = new FurtherDerivationGetChildrenSwitch();
        return childrenSwitch.doSwitch((AbstractContainer) parentElement);
    }

    @Override
    public Object getParent(Object element) {
        // Is not necessary
        return element;
    }

    @Override
    public boolean hasChildren(Object element) {
        FurtherDerivationHasChildrenSwitch hasChildrenSwitch = new FurtherDerivationHasChildrenSwitch();
        if (hasChildrenSwitch.doSwitch((AbstractContainer) element).length > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List<?>) {
            return ((List<?>) inputElement).toArray();
        } else {
            if (inputElement != null) {
                Object[] array = { inputElement };
                return array;
            }
        }
        return new Object[] {};
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub
    }
}
