package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener.FurtherDerivationCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener.FurtherDerivationComboListener;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.CompositeTaskContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.FurtherDerivationTreeContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.FurtherDerivationtTreeLabelProvider;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;

public class SelectElementTypesPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(SelectElementTypesPage.class);

    public static final int CHECKBOX_COLUMN_NO = 0;
    public static final int ELEMENT_TYPE_COLUMN_NO = 1;
    public static final int NAME_COLUMN_NO = 2;
    public static final int COMBO_COLUMN_NO = 3;
    public static final String[] HEADINGS_ARRAY = { "?", "Element Type", "Name", "Basic Activity" };

    private Tree changeSelectionTree;
    private TreeViewer treeViewer;
    private boolean itemIsIncomplete = false;
    private Map<TreeItem, Button> treeItemToCheckboxMap = new HashMap<TreeItem, Button>();
    private Map<Button, Combo> checkboxTocomboMap = new HashMap<Button, Combo>();

    private SurfaceFactory factory = new SurfaceFactory();

    public SelectElementTypesPage() {
        super("beginningPage");
    }

    @Override
    public void createControl(Composite parent) {

        Composite container = factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        getShell().setMinimumSize(600, 500);

        setTitle("If elements are grayed, it is not possible to uncheck them or change basic activity.");

        this.changeSelectionTree = factory.createTree(container, SWT.FILL, 1, true, SWT.BORDER
                | SWT.FULL_SELECTION, HEADINGS_ARRAY);
        factory.setGrabVerticalForGridData(this.changeSelectionTree, true, SWT.FILL, false);
        this.changeSelectionTree.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 22;
            }
        });

        this.treeViewer = new TreeViewer(this.changeSelectionTree);
        if (((FurtherDerivationWizard) getWizard()).getInput() != null) {
            setTreeViewerToTree(((FurtherDerivationWizard) getWizard()).getInput());
        }
        setControl(container);
    }

    public void setTreeViewerToTree(List<AbstractContainer> input) {

        if (input.size() > 0 && input.get(0) instanceof CompositeTaskDerivationContainer) {
            this.treeViewer.setContentProvider(new CompositeTaskContentProvider());
        } else {
            this.treeViewer.setContentProvider(new FurtherDerivationTreeContentProvider());
        }
        this.treeViewer.setLabelProvider(new FurtherDerivationtTreeLabelProvider());
        this.treeViewer.setInput(input);
        this.treeViewer.expandAll();

        checkAlreadyChosenContainers(this.changeSelectionTree.getItems());
        addCheckboxAndComboToTreeItems(this.changeSelectionTree, this.changeSelectionTree.getItems());

        this.changeSelectionTree.getColumn(CHECKBOX_COLUMN_NO).setWidth(100);
        this.changeSelectionTree.getColumn(ELEMENT_TYPE_COLUMN_NO).pack();
        this.changeSelectionTree.getColumn(NAME_COLUMN_NO).pack();
    }

    private void checkAlreadyChosenContainers(TreeItem[] items) {

        for (TreeItem item : items) {
            if (item.getItems().length > 0)
                checkAlreadyChosenContainers(item.getItems());

            AbstractContainer container = (AbstractContainer) item.getData();
            if (container.isSelected()) {
                item.setChecked(true);
            }
        }
    }

    public Tree getCurrentTree() {
        return this.changeSelectionTree;
    }

    public void addCheckboxAndComboToTreeItems(Widget directParentItem, TreeItem[] items) {
        for (TreeItem item : items) {

            if (item.getItems().length > 0) {
                addCheckboxAndComboToTreeItems(item, item.getItems());
            }

            AbstractContainer container = (AbstractContainer) item.getData();

            Combo combo = new Combo(this.changeSelectionTree, SWT.READ_ONLY);
            combo.addSelectionListener(new FurtherDerivationComboListener(item, combo, this));
            factory.setControlWithTableTreeEditor(this.changeSelectionTree, item, combo, COMBO_COLUMN_NO);

            Button checkbox = new Button(this.changeSelectionTree, SWT.CHECK);
            checkbox.addSelectionListener(new FurtherDerivationCheckboxListener(checkbox, combo, this, item));
            factory.setControlWithTableTreeEditor(this.changeSelectionTree, item, checkbox, CHECKBOX_COLUMN_NO);

            this.treeItemToCheckboxMap.put(item, checkbox);
            this.checkboxTocomboMap.put(checkbox, combo);

            // TODO: a better set of rules has to be defined to avoid inconsistencies!
            if (container instanceof InterfaceSelectionContainer || container instanceof DataTypeSelectionContainer) {
                combo.add(BasicActivity.CHANGE.toString());
            } else {

                combo.add("ADD");
                combo.add("CHANGE");
                combo.add("REMOVE");
            }
            if (container.isSelected()) {
                checkbox.setSelection(true);
            } else {
                combo.setEnabled(false);
            }
            if (checkIfRefinementIsSelected(item)) {
                checkCheckbox(item, false);
            }
            adaptMenuInCombo(item);
            if (container.isSelected()) {
                setSelectedBasicActivity(container.getBasicActivity(), combo);
            }
        }
    }

    private void setSelectedBasicActivity(BasicActivity basicActivity, Combo combo) {
        switch (basicActivity) {
        case ADD:
            combo.setText(BasicActivity.ADD.toString());
            break;
        case CHANGE:
            combo.setText(BasicActivity.CHANGE.toString());
            break;
        case REMOVE:
            combo.setText(BasicActivity.REMOVE.toString());
            break;
        default:
            combo.setText("");
        }
    }

    public Map<TreeItem, Button> getTreeItemTocheckboxMap() {
        return this.treeItemToCheckboxMap;
    }

    public boolean checkIfRefinementIsSelected(TreeItem item) {
        for (TreeItem child : item.getItems()) {
            if (this.treeItemToCheckboxMap.get(child).getSelection()) {
                return true;
            }
        }
        return false;
    }

    public void checkCheckbox(TreeItem item, boolean doCheck) {
        Button checkbox = this.treeItemToCheckboxMap.get(item);
        checkbox.setEnabled(doCheck);
        this.checkboxTocomboMap.get(checkbox).setEnabled(doCheck);
    }

    public void adaptMenuInCombo(TreeItem parentItem) {
        Assert.isNotNull(parentItem.getData(),
                "Selection container is missing at tree item for further derivation wizard");
        switch (((AbstractContainer) parentItem.getData()).getBasicActivity()) {
        case ADD:
            setMenuToCombo(parentItem, new BasicActivity[] { BasicActivity.ADD });
            break;
        case CHANGE:
            setMenuToCombo(parentItem, new BasicActivity[] { BasicActivity.ADD, BasicActivity.CHANGE,
                    BasicActivity.REMOVE });
            break;
        case REMOVE:
            setMenuToCombo(parentItem, new BasicActivity[] { BasicActivity.REMOVE });
            break;
        }
    }

    public void updateFinishButton(TreeItem[] treeItems) {

        for (TreeItem child : treeItems) {

            if (child.getItems().length > 0 && !this.itemIsIncomplete) {
                updateFinishButton(child.getItems());
            }

            Button currentCheckbox = this.treeItemToCheckboxMap.get(child);
            Combo combo = this.checkboxTocomboMap.get(currentCheckbox);
            if (currentCheckbox.getSelection() && combo.getSelectionIndex() == -1) {
                ((FurtherDerivationWizard) getWizard()).setCanFinish(false);
                setPageComplete(false);
                this.itemIsIncomplete = true;
                break;
            } else {
                if (!this.itemIsIncomplete) {
                    ((FurtherDerivationWizard) getWizard()).setCanFinish(true);
                    setPageComplete(true);
                }
            }
        }
    }

    private void setMenuToCombo(TreeItem parentItem, BasicActivity[] menuText) {
        for (TreeItem child : parentItem.getItems()) {
            Combo currentCombo = this.checkboxTocomboMap.get(this.treeItemToCheckboxMap.get(child));
            currentCombo.removeAll();
            currentCombo.clearSelection();
            for (BasicActivity basicActivity : menuText) {
                currentCombo.add(basicActivity.toString());
            }
            if (((AbstractContainer) child.getData()).isSelected()) {
                setSelectedBasicActivity(((AbstractContainer) child.getData()).getBasicActivity(), currentCombo);
            }
        }
    }

    public void resetItemIsIncompleteBoolean() {
        this.itemIsIncomplete = false;
    }

    public Tree getChangeSelectionTree() {
        return this.changeSelectionTree;
    }
}
