package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener.ChooseElementTypeListener;

public class FurtherForkPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(FurtherForkPage.class);

    public final static String COMPONENT_BUTTON = "Components";
    public final static String INTERFACE_BUTTON = "Interfaces";
    public final static String DATATYPE_BUTTON = "Datatype Definition";

    private SurfaceFactory factory = new SurfaceFactory();
    private SelectElementTypesPage page;

    public FurtherForkPage(SelectElementTypesPage page) {
        super("Select the Element type you want to add");
        this.page = page;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        setTitle("Choose the element type you want to add.");

        SelectionAdapter[] listener = { new ChooseElementTypeListener(page), new ChooseElementTypeListener(page),
                new ChooseElementTypeListener(page) };

        Composite buttons = factory.createVerticalButtonComposite(container, SWT.CENTER, SWT.FILL, new String[] {
                COMPONENT_BUTTON, INTERFACE_BUTTON, DATATYPE_BUTTON }, SWT.NONE, listener);
        ((GridLayout) buttons.getLayout()).verticalSpacing = 15;
        ((GridData) buttons.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData) buttons.getLayoutData()).verticalAlignment = SWT.CENTER;

        setControl(container);

    }

}
