package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.SelectElementTypesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class FurtherDerivationComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(FurtherDerivationComboListener.class);

    private SelectElementTypesPage selectElementTypesPage;
    private Combo combo;
    private TreeItem item;

    public FurtherDerivationComboListener(TreeItem item, Combo combo, SelectElementTypesPage selectElementTypesPage) {

        this.combo = combo;
        this.item = item;
        this.selectElementTypesPage = selectElementTypesPage;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        String selection = combo.getItem(combo.getSelectionIndex());

        if (selection.equals("ADD")) {
            ((AbstractContainer) this.item.getData()).setBasicActivity(BasicActivity.ADD);
        } else if (selection.equals("CHANGE")) {
            ((AbstractContainer) this.item.getData()).setBasicActivity(BasicActivity.CHANGE);
        } else if (selection.equals("REMOVE")) {
            ((AbstractContainer) this.item.getData()).setBasicActivity(BasicActivity.REMOVE);
        }

        this.selectElementTypesPage.adaptMenuInCombo(this.item);
        this.selectElementTypesPage.resetItemIsIncompleteBoolean();
        this.selectElementTypesPage.updateFinishButton(this.item.getParent().getItems());
    }
}
