package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;

import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.FurtherForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.SelectElementTypesPage;

public class ChooseElementTypeListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ChooseElementTypeListener.class);

    private SelectElementTypesPage selectionPage;

    public ChooseElementTypeListener(SelectElementTypesPage selectionPage) {
        super();
        this.selectionPage = selectionPage;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (e.widget instanceof Button) {
            if (((Button) e.widget).getText() == FurtherForkPage.COMPONENT_BUTTON) {
                // selectionPage.setPresentationIndicator(FurtherDerivationWizard.COMPONENT_DERIVATION);
                selectionPage.setTreeViewerToTree(((FurtherDerivationWizard) selectionPage.getWizard()).getInput());
                selectionPage.getWizard().getContainer().showPage(selectionPage);
                return;
            }
            if (((Button) e.widget).getText() == FurtherForkPage.INTERFACE_BUTTON) {
                // selectionPage.setPresentationIndicator(FurtherDerivationWizard.INTERFACE_DERIVATION);
                selectionPage.setTreeViewerToTree(((FurtherDerivationWizard) selectionPage.getWizard()).getInput());
                selectionPage.getWizard().getContainer().showPage(selectionPage);
                return;
            }
            if (((Button) e.widget).getText() == FurtherForkPage.DATATYPE_BUTTON) {
                // selectionPage.setPresentationIndicator(FurtherDerivationWizard.DATATYPE_DERIVATION);
                selectionPage.setTreeViewerToTree(((FurtherDerivationWizard) selectionPage.getWizard()).getInput());
                selectionPage.getWizard().getContainer().showPage(selectionPage);
                return;
            }
        }
        super.widgetSelected(e);
    }

}
