package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.ActivityCreationSwitch;
import de.fzi.kamp.service.workplanmanagement.AdaptationInsertingSwitch;
import de.fzi.kamp.service.workplanmanagement.AdaptationRemovalSwitch;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.SelectElementTypesPage;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;

public class FurtherDerivationWizard extends AbstractWizard implements IWizard {
    private final static Logger logger = Logger.getLogger(FurtherDerivationWizard.class);

    public final static int NORMAL_DERIVATION = 0;
    public final static int COMPONENT_DERIVATION = 1;
    public final static int INTERFACE_DERIVATION = 2;
    public final static int DATATYPE_DERIVATION = 3;

    private CompositeTaskDerivationContainer compositeTaskContainer;
    private WorkplanDerivationManager workplanManager;
    private SelectElementTypesPage selectionPage;
    // private FurtherForkPage forkPage;
    private IMainEditor editor;
    private Tree workplanTree;
    private boolean canFinish = false;

    private Activity activity;
    private List<AbstractContainer> input;

    public FurtherDerivationWizard(Tree workplanTree, IMainEditor editor) {
        this.editor = editor;
        this.selectionPage = new SelectElementTypesPage();
        // this.forkPage = new FurtherForkPage(this.selectionPage);
        this.workplanTree = workplanTree;

        TreeItem item = (TreeItem) this.workplanTree.getSelection()[0];
        this.activity = (Activity) item.getData();

        // The workplan manager is necessary to insert elements later
        if (workplanTree.getData() instanceof Workplan) {
            CompositeTask compositeTask = getCompositeTask(this.activity);
            this.compositeTaskContainer = (CompositeTaskDerivationContainer) compositeTask.getSelectioncontainer(); 
            this.workplanManager = new WorkplanDerivationManager(compositeTaskContainer);
        }

        this.input = new ArrayList<AbstractContainer>();
        this.input.add(getSelectedContainer());
    }

    @Override
    public boolean performFinish() {
        Map<TreeItem, Button> treeItemToCheckboxMap = this.selectionPage.getTreeItemTocheckboxMap();
        
        ActivityCreationSwitch activityCreationSwitch = new ActivityCreationSwitch();
        AdaptationInsertingSwitch adaptationInsertingSwitch = new AdaptationInsertingSwitch();
        AdaptationRemovalSwitch adaptationRemovalSwitch = new AdaptationRemovalSwitch();

        List<TreeItem> allTreeItems = new LinkedList<TreeItem>();
        getAllTreeItems(this.selectionPage.getChangeSelectionTree().getItems(), allTreeItems);

        
        for (TreeItem treeItem : allTreeItems) {
            if (!(treeItem.getData() instanceof CompositeTaskDerivationContainer)) {
                if (treeItemToCheckboxMap.get(treeItem).getSelection()
                        && ((AbstractContainer) treeItem.getData()).getActivity() == null) {
                    // Activity must be added to workplan
                    Activity activityToInsert = activityCreationSwitch.doSwitch((AbstractContainer) treeItem.getData());
                    adaptationInsertingSwitch.setActivityToInsert(activityToInsert);

                    AbstractContainer parentSelectionContainer = (AbstractContainer) activityToInsert.getSelectioncontainer().eContainer();
                    
                    if (parentSelectionContainer.getActivity() == null) {
                        parentSelectionContainer.setBasicActivity(BasicActivity.CHANGE);
                        activityCreationSwitch.doSwitch(parentSelectionContainer);
                    }
                    
                    adaptationInsertingSwitch.doSwitch(parentSelectionContainer.getActivity());
                } else {
                    if (((AbstractContainer) treeItem.getData()).getActivity() != null
                            && !treeItemToCheckboxMap.get(treeItem).getSelection()) {
                        // An activity must be removed from workplan
                        adaptationRemovalSwitch.setActivitytoremove(((AbstractContainer) treeItem.getData()).getActivity());
                        adaptationRemovalSwitch.doSwitch(((AbstractContainer) treeItem.getData()).getActivity().eContainer());
                    }
                }
            }
        }
        TreeViewer treeViewer = ((CentralEditorPage) this.editor.getCentralPage()).getWorkplanLayer().getAdapter()
                .getTreeViewer(this.workplanTree);
        treeViewer.refresh();
        return true;
    }

    public void addPages() {
        addPage(this.selectionPage);
        setWindowTitle("Select further Work Activities");
    }

    public AbstractContainer getSelectedContainer() {

        if (activity instanceof CompositeTask) {
            return this.compositeTaskContainer;
        }
        // TODO: Build switch for getContainerforTask method
        return this.workplanManager.getContainerForTask(activity);
    }

    public Task getSelectedTask() {
        // The "0" can be used, because just one element can be selected in the tree
        return (Task) ((TreeItem) this.workplanTree.getSelection()[0]).getData();
    }

    public CompositeTask getCompositeTask(Activity activity) {
        Activity currentActivity = activity;
        while (!(currentActivity instanceof CompositeTask)) {
            currentActivity = (Activity) currentActivity.eContainer();
        }
        return (CompositeTask) currentActivity;
    }

    public List<AbstractContainer> getInput() {
        return this.input;
    }

    @Override
    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public void getAllTreeItems(TreeItem[] treeItems, List<TreeItem> foundTreeItems) {

        for (TreeItem treeItem : treeItems) {
            foundTreeItems.add(treeItem);
            if (treeItem.getItems().length > 0) {
                getAllTreeItems(treeItem.getItems(), foundTreeItems);
            }
        }
    }
}
