package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ParentSearchSwitch extends StaticstructureSwitch<Object> {
    private final static Logger logger = Logger.getLogger(ParentSearchSwitch.class);

    private SAMMComponentProxy componentProxy;
    private boolean foundElement = false;
    private CompositeStructure currentParent;

    public ParentSearchSwitch(SAMMComponentProxy componentProxy) {
        super();
        this.componentProxy = componentProxy;
    }

    @Override
    public Object caseCompositeComponent(CompositeComponent compositeComponent) {

        for (SubcomponentInstance subInstance : compositeComponent.getSubcomponents()) {
            this.currentParent = compositeComponent;
            if (!(subInstance.getRealizedBy() == this.componentProxy.getComponenttype())) {
                doSwitch(subInstance.getRealizedBy());
            } else {
                this.foundElement = true;
            }
        }
        return compositeComponent;
    }

    public void setCurrentParent(CompositeStructure currentParent) {
        this.currentParent = currentParent;
    }

    public CompositeStructure getFoundParent() {
        return this.currentParent;
    }

    public boolean isElementFound() {
        return this.foundElement;
    }
}
