package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivityRefinement;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivityRefinement;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class FollowUpImplementationActivitiesSwitch extends ImplementationSwitch<Object> {
    private final static Logger logger = Logger.getLogger(FollowUpImplementationActivitiesSwitch.class);

    private List<Activity> resultingComponents;
    private FollowUpAdaptationActivitiesSwitch adaptationActivitiesSwitch;

    public FollowUpImplementationActivitiesSwitch(List<Activity> resultingComponents,
            FollowUpAdaptationActivitiesSwitch adaptationActivitiesSwitch) {
        this.adaptationActivitiesSwitch = adaptationActivitiesSwitch;
        this.resultingComponents = resultingComponents;
    }

    @Override
    public Object caseImplementDataTypeActivity(ImplementDataTypeActivity dataTypeActivity) {

        // for(dataTypeActivity.get)
        return dataTypeActivity;
    }

    @Override
    public Object caseImplementComponentActivity(ImplementComponentActivity implementComponentActivity) {
        for (ImplementComponentActivityRefinement refinement : implementComponentActivity.getRefinements()) {
            Object bla = doSwitch(refinement);
            if (!(bla instanceof Integer)) {
                this.resultingComponents.add(implementComponentActivity);
                break;
            }
        }
        return implementComponentActivity;
    }

    @Override
    public Object caseImplementOperationActivity(ImplementOperationActivity implementOperationActivity) {
        if (implementOperationActivity.isSignaturechange()) {
            return implementOperationActivity;
        }
        return -1;
    }

    @Override
    public Object caseImplementProvidedInterfaceportActivity(
            ImplementProvidedInterfaceportActivity providedInterfacePortActivity) {
        if (providedInterfacePortActivity.isSignaturechange()) {
            return providedInterfacePortActivity;
        }

        for (ImplementProvidedInterfaceportActivityRefinement interfacePortrefinement : providedInterfacePortActivity
                .getRefinements()) {
            Object returnedActivity = doSwitch(interfacePortrefinement);
            if (!(returnedActivity instanceof Integer)) {
                return providedInterfacePortActivity;
            }
        }
        return -1;
    }

    @Override
    public Object defaultCase(EObject object) {
        adaptationActivitiesSwitch.doSwitch(object);
        return (Activity) object;
    }

    // private void createTableItem(String elementName, Object elementData){
    // TableItem item = new TableItem(table, SWT.NONE);
    // item.setText(POSITION_ARCHITECTUREELEMENT_NAME, elementName);
    // item.setData(elementData);
    // }
}
