package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivityRefinement;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivityFollowup;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivityRefinement;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class FollowUpAdaptationActivitiesSwitch extends AdaptationSwitch<Object> {
    private final static Logger logger = Logger.getLogger(FollowUpAdaptationActivitiesSwitch.class);

    private Activity lastHandledActivity;
    private List<Activity> resultingComponents;

    private FollowUpImplementationActivitiesSwitch implementationActivitiesSwitch;

    public FollowUpAdaptationActivitiesSwitch(List<Activity> resultingComponents) {
        super();
        this.resultingComponents = resultingComponents;
        this.implementationActivitiesSwitch = new FollowUpImplementationActivitiesSwitch(resultingComponents, this);
    }

    @Override
    public Object caseChangeComponentImplementationActivity(ChangeComponentImplementationActivity componentActivity) {

        for (ChangeComponentImplementationActivityRefinement refinement : componentActivity.getRefinements()) {
            if (!(doSwitch(refinement) instanceof Integer)) {
                this.resultingComponents.add(componentActivity);
                break;
            }
        }
        return componentActivity;
    }

    @Override
    public Object caseChangeInterfaceportActivity(ChangeInterfaceportActivity interfacePortActivity) {
        if (interfacePortActivity.isSignaturechange()) {
            return interfacePortActivity;
        } else {
            for (ChangeInterfaceportActivityRefinement interfacePortrefinement : interfacePortActivity.getRefinements()) {
                Object returnedValue = doSwitch(interfacePortrefinement);
                if (!(returnedValue instanceof Integer)) {
                    return returnedValue;
                }
            }
        }
        return -1;
    }

    @Override
    public Object caseChangeDataTypeActivity(ChangeDataTypeActivity changeDataTypeActivity) {
        for (ChangeInterfaceDefinitionActivity interfaceActivity : changeDataTypeActivity.getFollowups()) {
            doSwitch(interfaceActivity);
        }
        return changeDataTypeActivity;
    }

    @Override
    public Object caseChangeInterfaceDefinitionActivity(ChangeInterfaceDefinitionActivity changeInterfaceDefAct) {

        for (ChangeInterfaceDefinitionActivityFollowup followUp : changeInterfaceDefAct.getFollowups()) {
            doSwitch(followUp);
        }

        return changeInterfaceDefAct;
    }

    @Override
    public Object caseChangeOperationImplementationActivity(ChangeOperationImplementationActivity operationActivity) {
        if (operationActivity.isSignaturechange()) {
            return operationActivity;
        }
        return -1;
    }

    @Override
    public Object caseRemoveOperationImplementationActivity(RemoveOperationImplementationActivity object) {
        // TODO Auto-generated method stub
        return object;
    }

    @Override
    public Object caseRemoveInterfaceportActivity(RemoveInterfaceportActivity object) {
        // TODO Auto-generated method stub
        return object;
    }

    @Override
    public Object defaultCase(EObject object) {
        if (object != this.lastHandledActivity) {
            this.implementationActivitiesSwitch.doSwitch(object);
        }
        return (Activity) object;
    }

    // private void createTableItem(String elementName, Object elementData){
    // TableItem item = new TableItem(table, SWT.NONE);
    // item.setText(POSITION_ARCHITECTUREELEMENT_NAME, elementName);
    // item.setData(elementData);
    // }
}
