package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ConnectedComponentSearchingSwitch extends StaticstructureSwitch<Object> {
    private final static Logger logger = Logger.getLogger(ConnectedComponentSearchingSwitch.class);

    private List<ComponentType> connectedComponentsList = new LinkedList<ComponentType>();
    private boolean foundConsideredComponent = false;
    private ComponentType consideredComponent;
    private boolean isFirstEndpoint = false;
    private EndPoint firstEndPoint = null;
    private EndPoint secondEndPoint = null;

    public ConnectedComponentSearchingSwitch(ComponentType consideredComponent) {
        this.consideredComponent = consideredComponent;
    }

    /**
     * Since the information about connectors connecting components is held by CompositeStructure
     * elements like CompositeComponents oder the ServiceArhcitectureModel itself, they are the
     * initial point for finding components connected to a special component. Hence, the entry point
     * in this class will always be this case.
     */
    @Override
    public Object caseCompositeStructure(CompositeStructure compositeStructure) {

        // The assumption here is, that a connector has always two endpoints
        for (Connector connector : compositeStructure.getConnector()) {

            this.foundConsideredComponent = false;
            // Is there any case where there are more than two component endpoints???
            // -> yes!
            // Here both endpoints of a connector are stored into an own variable,
            // so that it is possible to refer to them, if one of them holds the
            // searched component.
            int index = 0;
            for (EndPoint endPoint : connector.getEndpoints()) {
                if (index == 0) {
                    this.firstEndPoint = endPoint;
                } else {
                    this.secondEndPoint = endPoint;
                }
                index++;
            }

            // just to know which endpoint has been considered
            this.isFirstEndpoint = true;
            doSwitch(this.firstEndPoint);
            if (!this.foundConsideredComponent) {// if the first endpoint does not refer to the
                                                 // wanted component
                this.isFirstEndpoint = false;
                doSwitch(this.secondEndPoint);
            }

        }
        return compositeStructure;
    }

    @Override
    public Object caseComponentEndpoint(ComponentEndpoint componentEndpoint) {
        if (!foundConsideredComponent) {// for the case, that the wanted component has not been
                                        // found, yet
            if (!((InterfacePort) componentEndpoint.getPort()).isRequired()
                    && ((InterfacePort) componentEndpoint.getPort()).getProvidingComponentType() == this.consideredComponent) {

                this.foundConsideredComponent = true;
                doSwitch(getComplementaryEndpoint().getPort());
            }
        } else {// If the component has already been found, the task is to insert the connected
                // component
            // into the connected components list
            this.connectedComponentsList.add((ComponentType) ((InterfacePort) componentEndpoint.getPort())
                    .getProvidingComponentType());
        }
        return componentEndpoint;
    }

    @Override
    public Object caseSubcomponentEndpoint(SubcomponentEndpoint subcomponentEndpoint) {
        if (!foundConsideredComponent) {// for the case, that the wanted component has not been
                                        // found, yet
            if (!((InterfacePort) subcomponentEndpoint.getPort()).isRequired()
                    && subcomponentEndpoint.getSubcomponent().getRealizedBy() == this.consideredComponent) {

                this.foundConsideredComponent = true;
                doSwitch(getComplementaryEndpoint());
            }
        } else {// If the component has already been found, the task is to insert the connected
                // component
            // into the connected components list
            this.connectedComponentsList.add(subcomponentEndpoint.getSubcomponent().getRealizedBy());
        }
        return subcomponentEndpoint;
    }

    public List<ComponentType> getConnectedComponentsList() {
        return connectedComponentsList;
    }

    /**
     * To find an connected component, both endpoints of a connector have to be considered. Since
     * the connected component is always on the opposite side of a connector, the endpoint
     * <i>not</i> representing the component for which the connected components should be found has
     * to be returned. This is done here.
     * 
     * @return Endpoint
     */
    private EndPoint getComplementaryEndpoint() {
        if (isFirstEndpoint) {
            return this.secondEndPoint;
        } else {
            return this.firstEndPoint;
        }
    }
}
