package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.pages;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.ShowComponentConnectorsButtonListener;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.Names;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.StartingPageTableContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.StartingPageTableLabelProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.FollowUpAdaptationActivitiesSwitch;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;

public class StartingPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(StartingPage.class);

    private Tree workplanTree;
    private List<TableEditor> tableEditors;
    
    private SurfaceFactory factory = new SurfaceFactory();
    
    private static final int BUTTON_COLUMN_INDEX = 2;

    public StartingPage(Tree workplanTree) {
        super(Names.getStartingpageName());
        this.workplanTree = workplanTree;
        this.tableEditors = new LinkedList<TableEditor>();
    }

    @Override
    public void createControl(Composite parent) {

        Composite container = factory.createCompositeOrGroup(parent, 1, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        setTitle("Follow up calculator");
        setDescription("Here all marked architecture elements are shown, "
                + "which are affected by an signature change. Please choose \n"
                + " the architecture elements of which you know, that they" + "cause changes in connected components.");

        Table table = factory.createTable(container, 1, Names.getHeadingsForStartingPageTable(), SWT.FILL, true);
        factory.setGrabVerticalForGridData(table, true, SWT.FILL);
        table.addListener(SWT.MeasureItem, new Listener() {
            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        fillTable(table);

        setControl(container);
    }

    private void fillTable(Table table) {

        table.removeAll();
        removeAllTableEdtors();
        CompositeTask compositeTask = (CompositeTask) workplanTree.getSelection()[0].getData();

        List<Activity> resultingComponents = new LinkedList<Activity>();
        FollowUpAdaptationActivitiesSwitch acivitiesSwitch = new FollowUpAdaptationActivitiesSwitch(resultingComponents);
        for (Activity activity : compositeTask.getSubtasks()) {// top level activity level
            acivitiesSwitch.doSwitch(activity);
        }

        setContentAndLabelProvider(resultingComponents, table);
        setStartConnectorFollowingButtons(table);
        for (TableColumn column : table.getColumns()) {
            column.pack();
        }
    }

    private void setContentAndLabelProvider(List<Activity> resultingComponents, Table table) {
        TableViewer tableViewer = new TableViewer(table);
        StartingPageTableContentProvider contentProvider = new StartingPageTableContentProvider();
        StartingPageTableLabelProvider labelProvider = new StartingPageTableLabelProvider();

        tableViewer.setContentProvider(contentProvider);
        tableViewer.setLabelProvider(labelProvider);
        tableViewer.setInput(resultingComponents);
    }

    private void setStartConnectorFollowingButtons(Table table) {

        for (TableItem tableItem : table.getItems()) {

            Button button = new Button(table, SWT.NONE);
            button.setText("Go!"); // replace by icon
            button.addSelectionListener(new ShowComponentConnectorsButtonListener(
                    (CalculateFollowUpWizard) getWizard(), (ComponentActivity) tableItem.getData()));

            TableEditor tableEditor = new TableEditor(table);
            tableEditors.add(tableEditor);
            tableEditor.grabHorizontal = true;
            tableEditor.grabVertical = true;
            tableEditor.setEditor(button, tableItem, BUTTON_COLUMN_INDEX);
        }
    }

    private void removeAllTableEdtors() {
        for (TableEditor tableEditor : this.tableEditors) {
            tableEditor.dispose();
        }
    }
}