package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.pages;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.BackToFollowUpStartPage;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.Names;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.ConnectedCompsTableContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.ConnectedCompsTableLabelProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.ConnectedComponentSearchingSwitch;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.ParentSearchSwitch;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class ConnectedComponentsPage extends WizardPage {
    private final static Logger logger = Logger.getLogger(ConnectedComponentsPage.class);

    private SAMMComponentProxy componentProxy;
    private Label initialComponentLabel;
    private Table connectedCompsTable;
    private TableViewer tableViewer;
    private SurfaceFactory factory = new SurfaceFactory();
    
    public ConnectedComponentsPage() {
        super("connectorsPage");
    }

    @Override
    public void createControl(Composite parent) {

        setTitleAndTex();

        Composite frameComposite = factory
                .createCompositeOrGroup(parent, 3, SWT.LEFT, 1, SWT.NONE, true, 10, 10);

        createInitialComponentLabel(frameComposite);

        this.connectedCompsTable = factory.createTable(frameComposite, 1, Names
                .getHeadingsForConnectedCompsTable(), SWT.FILL, true);
        factory.setGrabVerticalForGridData(this.connectedCompsTable, true, SWT.FILL);
        setTableViewer();

        Button button = new Button(frameComposite, SWT.NONE);
        button.setText("back");// TODO: replace by icon
        button.addSelectionListener(new BackToFollowUpStartPage((CalculateFollowUpWizard) getWizard()));

        setControl(frameComposite);
    }

    private void setTitleAndTex() {
        setTitle("Connected Components");
        setMessage("Please select the components which are affected by an sgnature change in the component\n"
                + " shown on the left side.");

    }

    /**
     * The composite component which has been chosen in the workplan is given to the wizard by this
     * method.
     */
    public void setCurrentComponent(SAMMComponentProxy componentProxy) {
        this.componentProxy = componentProxy;
        updateTable();
    }

    /**
     * Table viewer for the table that displays all components where a signature change is planned.
     */
    private void setTableViewer() {
        this.tableViewer = new TableViewer(this.connectedCompsTable);
        tableViewer.setContentProvider(new ConnectedCompsTableContentProvider());
        tableViewer.setLabelProvider(new ConnectedCompsTableLabelProvider());
    }

    /**
     * Adapts the table to the properties of the selected composite component.
     */
    private void updateTable() {
        try {
            this.initialComponentLabel.setText(this.componentProxy.getName());
            List<ComponentType> connectedComponentsList = getConnectedComponents();
            if (connectedComponentsList != null) {
                this.tableViewer.setInput(connectedComponentsList);
                this.tableViewer.refresh();
            }

            for (TableItem tableItem : this.connectedCompsTable.getItems()) {
                TableEditor editor = new TableEditor(this.connectedCompsTable);
                editor.grabHorizontal = true;
                editor.grabVertical = true;

                Button componentMarkingButton = new Button(this.connectedCompsTable, SWT.NONE);
                componentMarkingButton.setText("Select");// TODO: Change name on button. This one is
                                                         // bad.

                editor.setEditor(componentMarkingButton, tableItem, 1);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Creates the label showing the name of the component that has been selected that from here a
     * signature change is propagating.
     * 
     * @param frameComposite
     */
    private void createInitialComponentLabel(Composite frameComposite) {

        Composite compositeForInitialCompLabels = factory.createCompositeOrGroup(frameComposite, 1, SWT.FILL, 1,
                SWT.BORDER, false, 5, 5);

        Label textLabel = new Label(compositeForInitialCompLabels, SWT.NONE);
        textLabel.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_TEXT));
        textLabel.setText("The component you have chosen is: ");

        this.initialComponentLabel = new Label(compositeForInitialCompLabels, SWT.NONE);
        this.initialComponentLabel.setFont(SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_HEADING));
        this.initialComponentLabel.setText("When initialized, it is empty.");
    }

    /**
     * Returns a list of all components which are connected to a selected one.
     * 
     * @return
     */
    private List<ComponentType> getConnectedComponents() {

        if (this.componentProxy != null) {
            CompositeStructure elementContainingComponent = getElementContainingComponent();
            ConnectedComponentSearchingSwitch connectedCompsSwitch = new ConnectedComponentSearchingSwitch(
                    this.componentProxy.getComponenttype());
            connectedCompsSwitch.doSwitch(elementContainingComponent);

            return connectedCompsSwitch.getConnectedComponentsList();
        }
        return null;
    }

    /**
     * Returns the parent element of a component. Either a component is contained in a composite
     * component or in the the SAMM itself.
     * 
     * @return
     */
    private CompositeStructure getElementContainingComponent() {
        ParentSearchSwitch searchingSwitch = new ParentSearchSwitch(componentProxy);
        SAMMArchitectureModelProxy sammProxy = (SAMMArchitectureModelProxy) this.componentProxy.eContainer();
        ServiceArchitectureModel sammModel = sammProxy.getServicearchitecturemodel();

        for (SubcomponentInstance subInstance : sammModel.getSubcomponents()) {
            searchingSwitch.setCurrentParent(sammModel);
            searchingSwitch.doSwitch(subInstance.getRealizedBy());
            if (searchingSwitch.isElementFound()) {
                break;
            }
        }
        return searchingSwitch.getFoundParent();
    }
}
