package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

public class SignatureChangeOperationCheckboxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(SignatureChangeOperationCheckboxListener.class);

    private OperationSelectionContainerDecorator operationDecorator;

    public SignatureChangeOperationCheckboxListener(OperationSelectionContainerDecorator operationDecorator) {
        super();
        this.operationDecorator = operationDecorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        OperationImplementationSelectionContainer container = (OperationImplementationSelectionContainer) operationDecorator.getTableItem()
                .getData();
        container.setSignaturechange(operationDecorator.getSignatureChangeCheckbox().getSelection());
        logger.info("Is operation signature change? " + container.isSignaturechange());
        super.widgetSelected(e);
    }
}
