package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;

public class SignatureChangeInterfacePortCheckboxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(SignatureChangeInterfacePortCheckboxListener.class);

    private InterfacePortSelectionContainerDecorator interfacePortDecorator;

    public SignatureChangeInterfacePortCheckboxListener(InterfacePortSelectionContainerDecorator interfacePortDecorator) {
        super();
        this.interfacePortDecorator = interfacePortDecorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        InterfacePortSelectionContainer container = (InterfacePortSelectionContainer) interfacePortDecorator
                .getTableItem().getData();
        container.setSignaturechange(interfacePortDecorator.getSignatureChangeCheckbox().getSelection());
        logger.debug("Is signature change? " + container.isSignaturechange());
        super.widgetSelected(e);
    }
}
