package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.Names;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.pages.ConnectedComponentsPage;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;

public class ShowComponentConnectorsButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ShowComponentConnectorsButtonListener.class);

    private CalculateFollowUpWizard wizard;
    private ComponentActivity component;

    public ShowComponentConnectorsButtonListener(CalculateFollowUpWizard wizard, ComponentActivity component) {
        this.wizard = wizard;
        this.component = component;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        ConnectedComponentsPage page = (ConnectedComponentsPage) this.wizard.getPage(Names.getConnectorspageName());
        page.setCurrentComponent((SAMMComponentProxy) component.getComponent());

        this.wizard.getContainer().showPage(page);

        super.widgetSelected(e);
    }
}
