package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.NamingChangingRationalPage;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;

public class RationalTextfieldsModifyListener implements ModifyListener {
    private final static Logger logger = Logger.getLogger(RationalTextfieldsModifyListener.class);

    private NamingChangingRationalPage page;
    private TaskRationale rationale;
    private boolean keyword;
    private Text text;

    public RationalTextfieldsModifyListener(Text text, NamingChangingRationalPage page, TaskRationale rationale,
            boolean keyword) {
        this.page = page;
        this.rationale = rationale;
        this.keyword = keyword;
        this.text = text;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        page.setPageComplete(page.canFlipToNextPage());

        if (text.getText().length() > 0) {
            if (keyword)
                rationale.setKeyword(text.getText());
            else
                rationale.setDescription(text.getText());
        }
    }

}
