package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectOperationPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class OperationComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(OperationComboListener.class);

    private SelectOperationPage page;
    private OperationSelectionContainerDecorator decorator;
    private boolean justChange;

    public OperationComboListener(SelectOperationPage page, OperationSelectionContainerDecorator decorator,
            boolean justChange) {
        this.page = page;
        this.decorator = decorator;
        this.justChange = justChange;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (justChange) {
            this.decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
        } else {
            switch (decorator.getCombo().getSelectionIndex()) {
            case 0:
                this.decorator.getContainer().setBasicActivity(BasicActivity.ADD);
                break;
            case 1:
                this.decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
                break;
            case 2:
                this.decorator.getContainer().setBasicActivity(BasicActivity.REMOVE);
            }
        }

        page.setPageComplete(page.checkedAndSelected());
        super.widgetSelected(e);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }
}
