package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectOperationPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;

public class OperationCheckBoxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(OperationCheckBoxListener.class);

    private SelectOperationPage page;
    private OperationSelectionContainerDecorator decorator;
    private InterfacePortSelectionContainer containerOfInterfacePort;

    public OperationCheckBoxListener(SelectOperationPage page, OperationSelectionContainerDecorator decorator,
            InterfacePortSelectionContainer containerOfInterfacePort) {

        this.page = page;
        this.decorator = decorator;
        this.containerOfInterfacePort = containerOfInterfacePort;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        this.decorator.getCombo().setEnabled(isSelected);
        this.decorator.getContainer().setSelected(isSelected);
        this.decorator.getSignatureChangeCheckbox().setEnabled(isSelected);

        if (isSelected)
            containerOfInterfacePort.getRefinements().add(decorator.getContainer());
        else
            containerOfInterfacePort.getRefinements().remove(decorator.getContainer());

        page.setPageComplete(page.checkedAndSelected());
    }
}
