package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class InterfacePortComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(InterfacePortComboListener.class);

    private SelectInterfacePortPage page;
    private InterfacePortSelectionContainerDecorator decorator;
    private boolean changeInterface;

    public InterfacePortComboListener(SelectInterfacePortPage page, InterfacePortSelectionContainerDecorator data,
            boolean changeInterface) {
        this.page = page;
        this.decorator = data;
        this.changeInterface = changeInterface;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (this.changeInterface) {
            decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
        } else {
            switch (decorator.getCombo().getSelectionIndex()) {
            case 0:
                decorator.getContainer().setBasicActivity(BasicActivity.ADD);

                break;
            case 1:
                decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
                break;
            case 2:
                decorator.getContainer().setBasicActivity(BasicActivity.REMOVE);
            }
        }

        page.setPageComplete(page.checkedAndSelected());
        super.widgetSelected(e);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }
}
