package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;

public class InterfacePortCheckBoxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(InterfacePortCheckBoxListener.class);

    private SelectInterfacePortPage page;
    private InterfacePortSelectionContainerDecorator decorator;

    public InterfacePortCheckBoxListener(SelectInterfacePortPage page,
            InterfacePortSelectionContainerDecorator interfaceSelectionContainer) {
        super();
        this.page = page;
        this.decorator = interfaceSelectionContainer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getContainer().setSelected(isSelected);
        decorator.getCombo().setEnabled(isSelected);
        decorator.getSignatureChangeCheckbox().setEnabled(isSelected);

        page.setPageComplete(page.checkedAndSelected());
    }
}