package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class InterfaceComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(InterfaceComboListener.class);

    private SelectInterfacesPage page;
    private InterfaceSelectionContainerDecorator decorator;

    public InterfaceComboListener(SelectInterfacesPage page, InterfaceSelectionContainerDecorator data) {
        this.page = page;
        this.decorator = data;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (decorator.getCombo() != null) {
            switch (decorator.getCombo().getSelectionIndex()) {
            case 0:
                decorator.getContainer().setBasicActivity(BasicActivity.ADD);

                break;
            case 1:
                decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
                break;
            }
            page.setPageComplete(page.checkedAndSelected());
            super.widgetSelected(e);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }
}
