package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;

public class InterfaceCheckboxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(InterfaceCheckboxListener.class);

    private InterfaceSelectionContainerDecorator decorator;
    private SelectInterfacesPage page;
    private DataTypeSelectionContainer datatypeContainer;

    public InterfaceCheckboxListener(InterfaceSelectionContainerDecorator decorator, SelectInterfacesPage page) {
        super();
        this.decorator = decorator;
        this.page = page;
    }

    public InterfaceCheckboxListener(InterfaceSelectionContainerDecorator decorator, SelectInterfacesPage page,
            DataTypeSelectionContainer datatypeContainer) {
        super();
        this.decorator = decorator;
        this.page = page;
        this.datatypeContainer = datatypeContainer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getCombo().setEnabled(isSelected);
        decorator.getContainer().setSelected(isSelected);

        if (page.getPreviousPage() instanceof SelectDatatypesPage) {
            if (isSelected) {
                datatypeContainer.getSelectedInterfaceSelectionContainers().add(decorator.getContainer());
            } else {
                if (datatypeContainer.getSelectedInterfaceSelectionContainers().contains(decorator.getContainer()))
                    datatypeContainer.getSelectedInterfaceSelectionContainers().remove(decorator.getContainer());
            }
        }
        page.setPageComplete(page.checkedAndSelected());
    }
}
