package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;

public class IPDatatypesCheckboxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(IPDatatypesCheckboxListener.class);

    private InterfacePortSelectionContainerDecorator decorator;
    private InterfaceSelectionContainer ifaceContainer;

    public IPDatatypesCheckboxListener(InterfacePortSelectionContainerDecorator decorator,
            InterfaceSelectionContainer ifaceContainer) {
        this.ifaceContainer = ifaceContainer;
        this.decorator = decorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getCombo().setEnabled(isSelected);
        decorator.getContainer().setSelected(isSelected);

        if (isSelected) {
            handleAddComponent(this.decorator.getContainer().getParent());
        } else {
            if (ifaceContainer.getFollowups().contains(this.decorator.getContainer())) {
                handleRemoveComponent(this.decorator.getContainer().getParent());
            }
        }

        super.widgetSelected(e);
    }

    // TODO
    // Move the process for adding related components to somewhere else

    private void handleAddComponent(ComponentSelectionContainer componentContainer) {
        if (!componentContainer.isSelected()) {
            componentContainer.setSelected(true);
            componentContainer.setBasicActivity(BasicActivity.CHANGE);
        }
    }

    private void handleRemoveComponent(ComponentSelectionContainer componentContainer) {
        if (!componentContainer.isSelected()) {
            componentContainer.setSelected(false);
            componentContainer.setBasicActivity(null);
        }
    }
}
