package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.ContainerDecoratorSuperclass;
import de.fzi.kamp.ui.workplanderivation.data.DataTypeSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class DataTypesComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(DataTypesComboListener.class);

    private WizardPage page;
    private ContainerDecoratorSuperclass decorator;

    public DataTypesComboListener(WizardPage page, ContainerDecoratorSuperclass decorator) {
        this.page = page;
        this.decorator = decorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetDefaultSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        ((DataTypeSelectionContainerDecorator) this.decorator).getContainer().setBasicActivity(BasicActivity.CHANGE);
        ((SelectDatatypesPage) page).setPageComplete(((SelectDatatypesPage) page).checkedAndSelected());
        super.widgetSelected(e);
    }

}
