package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import de.fzi.kamp.ui.workplanderivation.data.DataTypeSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;

public class DataTypeCheckboxListener implements SelectionListener {
    private final static Logger logger = Logger.getLogger(DataTypeCheckboxListener.class);

    private DataTypeSelectionContainerDecorator decorator;

    public DataTypeCheckboxListener(SelectDatatypesPage page, DataTypeSelectionContainerDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getContainer().setSelected(isSelected);
        decorator.getCombo().setEnabled(isSelected);
    }

}
