package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.ComponentSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;

public class ComponentComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ComponentComboListener.class);

    private SelectComponentActivitiesWizardPage page;
    private ComponentSelectionContainerDecorator decorator;

    public ComponentComboListener(SelectComponentActivitiesWizardPage page,
            ComponentSelectionContainerDecorator decorator) {
        super();
        this.page = page;
        this.decorator = decorator;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        switch (decorator.getCombo().getSelectionIndex()) {
        case 0:
            this.decorator.getContainer().setBasicActivity(BasicActivity.ADD);
            break;
        case 1:
            this.decorator.getContainer().setBasicActivity(BasicActivity.CHANGE);
            break;
        case 2:
            this.decorator.getContainer().setBasicActivity(BasicActivity.REMOVE);
        }

        page.setPageComplete(page.checkedAndSelected());
        super.widgetSelected(e);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

}
