package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.ComponentSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;

public class ComponentCheckBoxListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ComponentCheckBoxListener.class);

    private SelectComponentActivitiesWizardPage page;
    private ComponentSelectionContainerDecorator decorator;

    public ComponentCheckBoxListener(SelectComponentActivitiesWizardPage page,
            ComponentSelectionContainerDecorator decorator) {
        super();
        this.page = page;
        this.decorator = decorator;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getCombo().setEnabled(isSelected);
        decorator.getContainer().setSelected(isSelected);

        page.setPageComplete(page.checkedAndSelected());
    }
}
