package de.fzi.kamp.ui.workplanderivation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;

public class CheckBoxListenerInterfacePortIfInterfaceBefore extends SelectionAdapter {

    private final static Logger logger = Logger.getLogger(CheckBoxListenerInterfacePortIfInterfaceBefore.class);

    private SelectInterfacePortPage page;
    private InterfacePortSelectionContainerDecorator decorator;

    public CheckBoxListenerInterfacePortIfInterfaceBefore(SelectInterfacePortPage page,
            InterfacePortSelectionContainerDecorator interfaceSelectionContainer) {
        super();
        this.page = page;
        this.decorator = interfaceSelectionContainer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        boolean isSelected = decorator.getCheckbox().getSelection();
        decorator.getCombo().setEnabled(isSelected);
        decorator.getContainer().setSelected(isSelected);
        decorator.getSignatureChangeCheckbox().setEnabled(isSelected);

        if (isSelected) {
            decorator.getContainer().getInterfaceSelectionContainer().getFollowups().add(decorator.getContainer());
            handleAddComponent(decorator.getContainer().getParent());
        } else {
            decorator.getContainer().getInterfaceSelectionContainer().getFollowups().remove(decorator.getContainer());
            handleRemoveComponent(decorator.getContainer().getParent());
        }

        page.setPageComplete(page.checkedAndSelected());

    }

    private void handleAddComponent(ComponentSelectionContainer componentContainer) {
        componentContainer.setSelected(true);
        componentContainer.setBasicActivity(BasicActivity.CHANGE);
        componentContainer.getRefinements().add(decorator.getContainer());
    }

    private void handleRemoveComponent(ComponentSelectionContainer componentContainer) {
        componentContainer.setSelected(false);
        componentContainer.setBasicActivity(null);
        componentContainer.getRefinements().remove(decorator.getContainer());
    }
}
