package de.fzi.kamp.ui.workorganisation.listeners;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.workorganisation.Role;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;

public class TeamComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(TeamComboListener.class);

    private Combo teamCombo;
    private Combo roleCombo;
    private Label componentName;
    private SAMMComponentProxy component;
    private TableViewer assignedDevelopersViewer;

    public TeamComboListener(Combo teamCombo, Combo roleCombo, Label componentName, SAMMComponentProxy component,
            TableViewer assignedDevelopersViewer) {
        super();
        this.teamCombo = teamCombo;
        this.roleCombo = roleCombo;
        this.componentName = componentName;
        this.component = component;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    /**
     * This method fills the combo for the roles dependent on the selection of the team.
     */
    @Override
    public void widgetSelected(SelectionEvent e) {

        List<Role> rolesList = new LinkedList<Role>();
        this.roleCombo.setData(rolesList);

        if (teamCombo.getData() instanceof List<?>) {
            List<?> teams = (List<?>) teamCombo.getData();

            roleCombo.removeAll();
            // set default role value
            this.roleCombo.add("All");

            Team selectedTeam = (Team) teams.get(this.teamCombo.getSelectionIndex());

            for (SoftwareDeveloper developer : selectedTeam.getSoftwaredevelopers()) {
                this.roleCombo.add(developer.getName());
                rolesList.add(developer);
            }
            for (SoftwareArchitect architect : selectedTeam.getTeamarchitects()) {
                this.roleCombo.add(architect.getName());
                rolesList.add(architect);
            }
            this.assignedDevelopersViewer.setInput(component.getWorkorganisationelement());
        }

        this.componentName.setText(component.getName());

        super.widgetSelected(e);
    }

}
