package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;

import de.fzi.kamp.ui.workorganisation.MapElementsToDevelopersDialog;
import de.fzi.maintainabilitymodel.workorganisation.Company;

public class SelectSingleCompaniesButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(SelectSingleCompaniesButtonListener.class);

    private Button companyButton;
    private MapElementsToDevelopersDialog dialog;

    public SelectSingleCompaniesButtonListener(Button companyButton, MapElementsToDevelopersDialog dialog) {
        super();
        this.companyButton = companyButton;
        this.dialog = dialog;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (this.companyButton.getSelection())
            this.dialog.getSelectedCompaniesList().add((Company) companyButton.getData());
        else
            this.dialog.getSelectedCompaniesList().remove((Company) companyButton.getData());

        this.dialog.updateTeamsList();
        this.dialog.fillTable();
        super.widgetSelected(e);
    }

}
