package de.fzi.kamp.ui.workorganisation.listeners;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.workorganisation.Role;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;

public class RoleComboListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(RoleComboListener.class);

    private Combo rolesCombo;
    private TableItem item;
    private Combo teamsCombo;
    private TableViewer assignedDevelopersViewer;
    private Map<SAMMComponentProxy, WorkOrganisationElement> currentMappingMap;

    public RoleComboListener(Combo rolesCombo, TableItem item, Combo teamsCombo, TableViewer assignedDevelopersViewer,
            Map<SAMMComponentProxy, WorkOrganisationElement> currentMappingMap) {
        super();
        this.rolesCombo = rolesCombo;
        this.item = item;
        this.teamsCombo = teamsCombo;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
        this.currentMappingMap = currentMappingMap;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    /**
     * This method fills the map for components and their selected workorganisation elements.
     */
    @Override
    public void widgetSelected(SelectionEvent e) {

        if (item.getData() instanceof SAMMComponentProxy) {
            SAMMComponentProxy component = (SAMMComponentProxy) item.getData();
            if (this.currentMappingMap.containsKey(component))
                this.currentMappingMap.remove(component);

            if (rolesCombo.getSelectionIndex() == 0) {
                Team selectedTeam = ((List<Team>) teamsCombo.getData()).get(teamsCombo.getSelectionIndex());
                this.currentMappingMap.put(component, selectedTeam);
            } else {
                List<Role> role = ((List<Role>) rolesCombo.getData());
                this.currentMappingMap.put(component, role.get(rolesCombo.getSelectionIndex() - 1));
            }
            this.assignedDevelopersViewer.setInput(component.getWorkorganisationelement());
        }

        super.widgetSelected(e);
    }

}
