package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

public class MapElementsToTeamsButtonlistener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(MapElementsToTeamsButtonlistener.class);

    private Table table;
    private IPreparationManager prepManager;
    private Display display;
    private IMainEditor editor;

    public MapElementsToTeamsButtonlistener(Table table, IPreparationManager prepManager, Display display,
            IMainEditor editor) {
        this.table = table;
        this.prepManager = prepManager;
        this.display = display;
        this.editor = editor;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        // I assume that there is just one WorkorganisationModel
        if (table.getSelection().length > 0) {
            TableItem item = table.getSelection()[0];
            this.prepManager.openMapElementsToDevelopersDialog(((ArchitecturalAlternative) item.getData())
                    .getMaintainabilityanalysismodel().getWorkorganisation().get(0), ((ArchitecturalAlternative) item
                    .getData()).getArchitecturemodel(), this.display, this.editor);
        }

        super.widgetSelected(e);
    }
}
