package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.service.commands.DeleteSingleWOElementAssignmentCommand;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;

public class DeleteWOElementSelectionistener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(DeleteWOElementSelectionistener.class);

    private WorkOrganisationElement workorganisationElement;
    private AbstractModelElement correspondingModelElement;
    private TableViewer tableViewer;
    private ICommandHandler commandHandler;

    public DeleteWOElementSelectionistener(WorkOrganisationElement workorganisationElement,
            ICommandHandler commandHandler, TableViewer tableViewer, AbstractModelElement correspondingModelElement) {
        super();
        this.workorganisationElement = workorganisationElement;
        this.commandHandler = commandHandler;
        this.correspondingModelElement = correspondingModelElement;
        this.tableViewer = tableViewer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        MessageDialog dialog = new MessageDialog(null, "Confirmation", null, "Do you really want to delete "
                + this.workorganisationElement.getName() + " from " + this.correspondingModelElement.getName() + "?",
                0, new String[] { "Ok", "Cancel" }, 0);

        dialog.open();

        if (dialog.getReturnCode() == Dialog.OK) {
            DeleteSingleWOElementAssignmentCommand command = new DeleteSingleWOElementAssignmentCommand(
                    this.workorganisationElement, this.correspondingModelElement, this.tableViewer);
            this.commandHandler.handleCommand(command);
        }

        super.widgetSelected(e);
    }

}
