package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.ui.activator.Activator;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;

public class ContextMenuForDeletingAssignedWOElementListener extends MouseAdapter {
    private final static Logger logger = Logger.getLogger(ContextMenuForDeletingAssignedWOElementListener.class);

    private ICommandHandler commandHandler;
    private TableViewer assignedDevelopersViewer;
    private Table mappingTable;
    private static final int RIGHT_MOUSE_BUTTON = 3;

    public ContextMenuForDeletingAssignedWOElementListener(ICommandHandler editor,
            TableViewer assignedDevelopersViewer, Table mappingTable) {
        super();
        this.commandHandler = editor;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
        this.mappingTable = mappingTable;
    }

    @Override
    public void mouseDown(MouseEvent e) {

        if (e.button == RIGHT_MOUSE_BUTTON) {
            if (e.widget instanceof Table) {
                Table table = (Table) e.widget;
                Menu rightButton = new Menu(table);

                if (getSelectedComponent() != null) {
                    AbstractModelElement modelElement = getSelectedComponent();

                    MenuItem deleteItem = createMenuItem(rightButton, SWT.CASCADE,
                            "Delete selected workorganisation element");
                    if (table.getSelection()[0] != null
                            && table.getSelection()[0].getData() instanceof WorkOrganisationElement) {
                        TableItem selectedItem = (TableItem) table.getSelection()[0];
                        WorkOrganisationElement workorganisationElement = (WorkOrganisationElement) selectedItem
                                .getData();
                        deleteItem.addSelectionListener(new DeleteWOElementSelectionistener(workorganisationElement,
                                this.commandHandler, this.assignedDevelopersViewer, modelElement));
                    }
                    table.setMenu(rightButton);
                }
            }
        }
        super.mouseDown(e);
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(text);

        ImageDescriptor desc = Activator.getImageDescriptor("/icons/qimpress.gif");

        item.setImage(desc.createImage());

        return item;
    }

    private AbstractModelElement getSelectedComponent() {

        if (this.mappingTable.getSelection()[0].getData() instanceof AbstractModelElement) {
            return (AbstractModelElement) this.mappingTable.getSelection()[0].getData();
        } else
            return null;

    }
}
