package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;

public class ComponentToMapListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ComponentToMapListener.class);

    private Table teamSelectionTable;
    private Label componentName;
    private TableViewer assignedDevelopersViewer;

    public ComponentToMapListener(Table table, Label componentName, TableViewer assignedDevelopersViewer) {
        super();
        this.teamSelectionTable = table;
        this.componentName = componentName;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        TableItem item = this.teamSelectionTable.getItem(this.teamSelectionTable.getSelectionIndex());
        if (item.getData() != null) {
            SAMMComponentProxy component = ((SAMMComponentProxy) item.getData());
            this.componentName.setText(component.getComponenttype().getName());
            this.assignedDevelopersViewer.setInput(component.getWorkorganisationelement());
            this.assignedDevelopersViewer.refresh();
        }
        super.widgetSelected(e);
    }

}
