package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.commands.ClearWorkorganisationElementsCommand;
import de.fzi.kamp.service.maineditor.ICommandHandler;

public class ClearAssignedDevelopersButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(ClearAssignedDevelopersButtonListener.class);

    private Table table;
    private ICommandHandler commandHandler;
    private TableViewer assignedDevelopersViewer;

    public ClearAssignedDevelopersButtonListener(Table table, TableViewer assignedDevelopersViewer,
            ICommandHandler commandHandler) {
        super();
        this.table = table;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
        this.commandHandler = commandHandler;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    /**
     * Deletes all WorkOrganisationElements in the list of the selected component. But the user has
     * to confirm that he really wants to clear the list.
     */
    @Override
    public void widgetSelected(SelectionEvent e) {

        if (this.table.getSelectionIndex() >= 0) {
            TableItem item = this.table.getItem(this.table.getSelectionIndex());

            MessageDialog dialog = new MessageDialog(null, "Cleraing confirmation", null,
                    "Do you really want to clear the assignments?", 0, new String[] { "Ok", "Cancel" }, 0);

            dialog.open();

            if (dialog.getReturnCode() == Dialog.OK) {
                ClearWorkorganisationElementsCommand command = new ClearWorkorganisationElementsCommand(item,
                        assignedDevelopersViewer);
                this.commandHandler.handleCommand(command);
            }
        }
        super.widgetSelected(e);
    }
}
