package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workorganisation.MapElementsToDevelopersDialog;

public class AllOrSingleCompaniesButtonListener extends SelectionAdapter {

    private final static Logger logger = Logger.getLogger(AllOrSingleCompaniesButtonListener.class);

    private boolean singleCompanies;
    private MapElementsToDevelopersDialog dialog;

    public AllOrSingleCompaniesButtonListener(boolean singleCompanies, MapElementsToDevelopersDialog dialog) {
        super();
        this.singleCompanies = singleCompanies;
        this.dialog = dialog;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        dialog.setCompanySelectionButtonsEnabled(singleCompanies);
        if (singleCompanies) {
            dialog.setAllCompaniesSelected();
            dialog.updateTeamsList();
            dialog.fillTable();
        }
        super.widgetSelected(e);
    }
}
