package de.fzi.kamp.ui.workorganisation.listeners;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.fzi.kamp.ui.workorganisation.MapElementsToDevelopersDialog;

public class AddDeveloperButtonListener extends SelectionAdapter {

    private final static Logger logger = Logger.getLogger(AddDeveloperButtonListener.class);

    private MapElementsToDevelopersDialog dialog;
    private TableViewer assignedDevelopersViewer;

    public AddDeveloperButtonListener(MapElementsToDevelopersDialog dialog, TableViewer assignedDevelopersViewer) {
        super();
        this.dialog = dialog;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    /**
     * Applies the changes made in the central table of the MapElementsToDevelopersDialog.
     */
    @Override
    public void widgetSelected(SelectionEvent e) {

        this.dialog.applyDeveloperAssignments();
        this.assignedDevelopersViewer.refresh();

        super.widgetSelected(e);
    }
}
